#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <operator.h>
#include <graph.h>
#include <colorerror.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class TestOperator : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(TestOperator);
  CPPUNIT_TEST(testExecuteSuccess);
  CPPUNIT_TEST(testExecuteFail);
  CPPUNIT_TEST_SUITE_END();

public:
  void testExecuteSuccess() {
    Graph g;
    FakeOperator op(g, false);
    
    CPPUNIT_ASSERT_EQUAL( true, op() );
    CPPUNIT_ASSERT_EQUAL( true, op.postExec_ );
  }
  
  void testExecuteFail() {
    Graph g;
    FakeOperator op(g, true);
    
    CPPUNIT_ASSERT_THROW( op(), ColorError );
    CPPUNIT_ASSERT_EQUAL( true, op.postExec_ );
  }
  
private:
  class FakeOperator : public Operator {
  public:
    FakeOperator(Graph& g, bool doThrow) : Operator("Fake", g), throw_(doThrow), postExec_(false) {
    }
    
    bool throw_;
    bool postExec_;
    
  private:
    bool execute() {
      if(throw_) 
        throw ColorError();
      return true;
    }    
    
    void postExecute() {
      postExec_ = true;
    }
  };

};

CPPUNIT_TEST_SUITE_REGISTRATION(TestOperator);

}	// end namespace NS_NOMORE_TESTS
