#ifndef TEST_COMMON_H
#define TEST_COMMON_H
#include <algorithm>
#include <heuristic.h>
namespace NS_NOMORE {

class Node;
class Graph;
class NoConstraint : public Constraint {
public:
  virtual bool isSatisfiedBy(const HeadNode&) const {
    return true;
  }
  virtual bool isSatisfiedBy(const BodyNode&) const {
    return true;
  }
  virtual bool supersedes(const Node& n1, const Node& n2) const {
    return true;
  }
};

}

//! Contains Tests for the NoMoRe++ library
namespace NS_NOMORE_TESTS {

template <class Cont>
inline bool findNode(const Cont& s, const NS_NOMORE::Node& b) {
  return std::find(s.begin(), s.end(), &b) != s.end();
}

template <class Iter>
inline bool findNode(Iter first, Iter last, const NS_NOMORE::Node& n) {
	return std::find(first, last, &n) != last;
}

}
#endif
