/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_STOUT_PRINTER_H
#define NOMORE_STOUT_PRINTER_H

#include <printer.h>

namespace NS_NOMORE {

//! Prints the answer sets of the graph to stdout.
/*! Use this class to print all plus colored head nodes (the name of the atoms 
 *  corresponding to the head node) to stdout in a format like smodels and 
 *  nomore++ v1.0. */
class StdoutPrinter : public Printer {
public:
  //! Constructs the object.
  StdoutPrinter() {
  }

  //! Prints the answer set to stdout.
  /*! The answer set of the graph is the union of all plus colored head nodes (atoms)
   *  of the graph.
   *  The output looks like:
   *  \code
   *  Answer: 1
   *  a b d e d
   *  \endcode
   *  where <b> a, b, d, e</b> and <b>d</b> are atoms which are colored plus in the
   *  graph.
   *  \pre The graph has been colored totally.
   *  \param nr The current number of the answer to print.
   *  \param grp The totally colored graph.*/
  virtual void operator()(int nr, const Graph& grp);
};

}

#endif
