/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_INVOCATION_DECORATOR_H
#define LIBNOMORE_INCOCATION_DECORATOR_H

#include <operator.h>

namespace NS_NOMORE {


//! decorates an operator's execution with an OperatorStarted event
class InvocationDecorator : public Operator {
public:
  class Observer {
  public:
    virtual ~Observer() {}
    virtual void onOperatorStarted(const std::string& name) = 0;
  };

  //! Creates the Decorator
  /*! \param op the Operator whose execution should be decorated */
  explicit InvocationDecorator(Operator* op, Observer* o);

  //! Destroys the decorator and the decorated operator
  virtual ~InvocationDecorator();

  virtual Operator* extractOperator(const std::string& name);

  //! forwards to the decorated operator
  bool validate(const OpSet& ops) const;
  
  //! forwards to the decorated operator
  void reset();

  
  //! forwards to the decorated operator
  ColorOpResult operator()();

private:
  Operator *operator_;
  Observer* o_;
};


}

#endif
