/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <operator.h>
#include <graph.h>

namespace NS_NOMORE {

Operator* Operator::extractOperator(const std::string& name) {
  return getName() == name ? this : 0;
}

Operator::Operator(const std::string& name) : name_(name) {
}

Operator::Operator(const std::string& name, Graph&) : name_(name) {
}

Operator::~Operator() {
}

bool Operator::validate(const OpSet&) const {
  return true;
}

void Operator::reset() {

}

PropOperator::PropOperator(const std::string& name, Graph& grp)
  : Operator(name, grp)
  , graph_(&grp) {

}


ColorOpResult PropOperator::operator()() {
  size_t ucBefore = graph_->countUncoloredNodes();
  execute();
  if (graph_->hasConflict()) {
    return ColorOperation::failed;
  }
  else if (ucBefore != graph_->countUncoloredNodes()) {
    return ColorOperation::succeeded;
  }
  else {
    return ColorOperation::unchanged;
  }
}

}
