#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/hybrid_lookahead_heuristic.h>
#include <head_node.h>
#include <body_node.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class HybridLookaheadHeuristicTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(HybridLookaheadHeuristicTest);
  CPPUNIT_TEST(testNoChoices);
  CPPUNIT_TEST(testNoValue);
  CPPUNIT_TEST(testMixedValues);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph();
    heu = new HybridLookaheadHeuristic();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete heu;
    delete graph;
  }

  void testNoChoices() {
    CPPUNIT_ASSERT_EQUAL( (Node*)0, heu->selectNode(noConstraint) );
  }

  void testNoValue() {
    graph->insertBodyNode();
    graph->insertBodyNode();
    graph->insertBodyNode();
    
    CPPUNIT_ASSERT( 0 == heu->selectNode(noConstraint) );
  }

  void testMixedValues() {
    BodyNode* bn[4];
    for (int i = 0; i != 4; ++i)
      bn[i] = graph->insertBodyNode();

    HeadNode* hn1 = graph->insertHeadNode(1);
    HeadNode* hn2 = graph->insertHeadNode(2);
   

    heu->handle(LookaheadExecution(ActivityState::started));
    heu->addHeuristicValue(bn[0], HybridLookahead::HeuristicValueType(2));
    heu->addHeuristicValue(bn[2], HybridLookahead::HeuristicValueType(1));
    heu->addHeuristicValue(bn[3], HybridLookahead::HeuristicValueType(3));
    heu->addHeuristicValue(hn1, HybridLookahead::HeuristicValueType(7));
    heu->addHeuristicValue(hn2, HybridLookahead::HeuristicValueType(1));
    heu->handle(LookaheadExecution(ActivityState::finished));
    CPPUNIT_ASSERT_EQUAL( static_cast<Node*>(bn[3]), heu->selectNode(OnlyBodies()) );
    CPPUNIT_ASSERT_EQUAL( (Node*)hn1, heu->selectNode(noConstraint) );
  }

private:
  NoConstraint noConstraint;
  Graph* graph;
  HybridLookaheadHeuristic* heu;
  
};

CPPUNIT_TEST_SUITE_REGISTRATION(HybridLookaheadHeuristicTest);

} // end namespace NS_NOMORE_TESTS
