#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/neg_precond_count.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class NegPreconditionCountHeuristicsTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(NegPreconditionCountHeuristicsTest);
  CPPUNIT_TEST(testCheck1);
  CPPUNIT_TEST(testCheck2);
  CPPUNIT_TEST(testCheck3);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph();
    
    body1 = graph->insertBodyNode();
    body2 = graph->insertBodyNode();
    body3 = graph->insertBodyNode();
    
    head1 = graph->insertHeadNode(4);
    head2 = graph->insertHeadNode(5);
    head3 = graph->insertHeadNode(6);
    head4 = graph->insertHeadNode(7);

    heu = new NegativePreconditionCount();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete graph;
    delete heu;
  }

  void testCheck1() {
    head1->insertZeroSuccessor(*body1);
    head3->insertOneSuccessor(*body1);

    head1->insertZeroSuccessor(*body2);
    head2->insertOneSuccessor(*body2);
    head4->insertOneSuccessor(*body2);

    head1->insertZeroSuccessor(*body3);
    head4->insertOneSuccessor(*body3);

    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body2, heu->selectNode(OnlyBodies()) );
  }

  void testCheck2() {
    NoConstraint c;

    head1->insertZeroSuccessor(*body1);
    head4->insertOneSuccessor(*body1);

    head2->insertZeroSuccessor(*body2);
    head1->insertZeroSuccessor(*body2);
    head3->insertOneSuccessor(*body2);

    head3->insertOneSuccessor(*body3);
    head4->insertOneSuccessor(*body3);

    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body3, heu->selectNode(OnlyBodies()) );
  }

  void testCheck3() {
    NoConstraint c;

    head1->insertZeroSuccessor(*body1);
    head3->insertOneSuccessor(*body1);
    head2->insertOneSuccessor(*body1);

    head2->insertZeroSuccessor(*body2);
    head3->insertOneSuccessor(*body2);

    head4->insertOneSuccessor(*body3);

    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body1, heu->selectNode(OnlyBodies()) );
  }

private:
  BodyNode* body1;
  BodyNode* body2;
  BodyNode* body3;
  
  HeadNode* head1;
  HeadNode* head2;
  HeadNode* head3;
  HeadNode* head4;

  NegativePreconditionCount *heu;
  Graph* graph;

  NoConstraint noConstraint;
};

CPPUNIT_TEST_SUITE_REGISTRATION(NegPreconditionCountHeuristicsTest);

} // end namespace NS_NOMORE_TESTS
