/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_NOMORE_APP_H_INCLUDED
#define NOMORE_NOMORE_APP_H_INCLUDED
#ifdef KDEVELOP
  #include "program_options.h"
#else
  #include "program_opts/program_options.h"
#endif
#include <solver.h>
#include <stats.h>
#include <operator.h>
#include <object_factory.h>
#include <string>
#include <memory>
#include <stack.h>

class NomoreApp {
public:
  NomoreApp(int& argc, char** argv);

  int run();

  void printHelp() const;
  void printVersion() const;
  void printOperators() const;
  void printHeuristics() const;
private:
  ProgramOptions::OptionGroup options_;
  ProgramOptions::OptionValues values_;
  std::auto_ptr<NS_NOMORE::ObjectFactory> factory_;

  std::string buildOpString() const;
  void printInfo(const NS_NOMORE::Solver& p) const;
  void validateArguments() const;
  std::string addHeuristicName(std::string opStr) const;
  std::auto_ptr<NS_NOMORE::Solver> createSolver(NS_NOMORE::Graph& g, 
    NS_NOMORE::Statistics& s,
    const std::string& opString) const;   

  std::auto_ptr<NS_NOMORE::Statistics> createStatisticObject(NS_NOMORE::Graph& g) const;
};

class CommandLineError : public std::runtime_error
{
public:
	CommandLineError(const std::string& msg)
		: std::runtime_error(msg)
	{}
};

#endif
