/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_NEG_PRECONDITION_COUNT_HEURISTIC_H
#define LIBNOMORE_NEG_PRECONDITION_COUNT_HEURISTIC_H
#include <static_heuristic.h>
#include <body_node.h>
#include <functional>
namespace NS_NOMORE {

//! Heuristic-Strategy that compares negative preconditions of body nodes.
/*! This class evaluates all nodes and set their heuristics values 
 *  to the number of negative preconditions (the count of 1-predecessors).
 *  For head nodes this heuristics count the number of 1-predecessors of its
 *  predecessors.
 *
 *  \note Body and head nodes can be evaluated.
 *  \note This Strategy may be used with either a Static- or a Dynamic-Heuristic.
 *  But since the heuristic value won't change over the time, the former
 *  is more sensible.
 */
class NegativePreconditionCountStrat {
public:
  //! value type of the strategie
  typedef size_t ValueType;

  //! the greater comparator
  typedef std::greater<ValueType> ComparatorType;

  //! evalutes the node and set the heuristic value
  struct Evaluate {
    ValueType operator()(Node* n, double tf) const {
      if (n->getType() == NodeType::body_node) {
        return tf * static_cast<BodyNode*>(n)->countNegBodyAtoms();
      }
      else {        
        assert(n->getType() == NodeType::head_node);

        ValueType num = 0;        
        HeadNode* hn = static_cast<HeadNode*>(n);
        for(HeadNode::BodyNodeIterator it = hn->predecessorsBegin();
          it != hn->predecessorsEnd(); ++it) {
            num += (*it)->countNegBodyAtoms();
        }
        return tf * num;
      }
    }
  };

  //! evaluator type of the strategie
  typedef Evaluate EvaluatorType;
};

//! A static heuristic that uses NegativeWeightArcsCountStrat as strategy.
typedef StaticHeuristic<NegativePreconditionCountStrat> NegativePreconditionCount;

}
#endif
