/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_UNFOUNDED_LOOPS_OPERATOR_H
#define NOMORE_UNFOUNDED_LOOPS_OPERATOR_H

#include <operator.h>
#include <color.h>
#include <head_node.h>
#include <deque>
#include "../src/detail/functors.h"
#include <set>
#include <map>

namespace NS_NOMORE {

class HeadNode;
class BodyNode;
struct BodyNodeColored;
struct BodyNodeColoredChoicePoint;
struct HeadNodeColoredChoicePoint;
struct GraphConstructionFinished;

class UnfoundedLoopsOperator : public PropOperator {
public:
  //! Creates the operator.
  /*! \param grp The graph the operator should work on. 
   *  \note
   *  If the graph does not contain any non-trivial strong components the operator
   *  disables itself - i.e. it becomes a noop.
   * 
   */ 
  explicit UnfoundedLoopsOperator(Graph& grp);

  //! Handles the GraphConstructionFinished event
  void handle(const GraphConstructionFinished& e);

  
  //! Handles a BodyNodeColored event fired by any body node which has been colored.
  void handle(const BodyNodeColored& e);
  
  //! Handles a BodyNodeColoredChoicePoint event fired by any body node which has been colored as choice point.
  void handle(const BodyNodeColoredChoicePoint& e);

  //! Handles a BodyNodeColoredChoicePoint event fired by any body node which has been colored as choice point.
  void handle(const HeadNodeColoredChoicePoint& e);

  //! Returns the name of the operator.
  const char* getName() const;
  
  /*!
   * returns true if the operator has disabled itself because the graph does not
   * contain any non-trivial strong components.
   */
  bool isDisabled() const;

private:
  typedef std::deque<HeadNode*> TodoList;
  typedef std::vector<HeadNode*> Stack;

  typedef std::set<HeadNode*, DETAIL::LessDerefId> WellFoundedHeadList;
  typedef std::multimap<BodyNode*, HeadNode*, DETAIL::LessDerefId> WellFoundedBodyList;



  void updateTodoList(BodyNode*);
  void updateWFList(BodyNode*);

  bool checkLoop(HeadNode* h);

  BodyNode* getWellfounded(HeadNode* head, int masterComponent) const;
  bool loopIsUnfounded(const Stack& loop) const;

  void color(const Stack& loop);

  HeadNode::BodyNodeIterator pickBody(HeadNode* head, HeadNode::BodyNodeIterator start, const Stack& dfsStack, const Stack& loop) const;
  HeadNode* pickHead(BodyNode* body, int component) const;

  void addToWFList(HeadNode* h, BodyNode* b);
  inline bool isInWFList(HeadNode* h) const;
  inline void clearWFList();
  
  bool disabled_;
  
  //! Executes the operator and generates the maximal support graph described in the detailed description of the class.
  void execute();

  
  //! Resets all members.
  virtual void reset();

  
  TodoList todo_;
  WellFoundedHeadList wellFoundedHeads_;
  WellFoundedBodyList wellFoundedBodies_;

};

}

#endif
