/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#include <heuristics/random.h>
#include <head_node.h>
#include <body_node.h>
#include <stdlib.h>
namespace NS_NOMORE {

///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(StaticRandom*) {
  return "SRand";
}

template <>
const char* getName(StaticRandomHeads*) {
  return "SRandHeads";
}

template <>
const char* getName(DynamicRandom*) {
  return "DRand";
}

template <>
const char* getName(DynamicRandomHeads*) {
  return "DRandHeads";
}

template <>
Heuristic* createHeuristic(StaticRandom*) {
  return new StaticRandom();
}
template <>
Heuristic* createHeuristic(StaticRandomHeads*) {
  return new StaticRandomHeads();
}
template <>
Heuristic* createHeuristic(DynamicRandom*) {
  return new DynamicRandom();
}
template <>
Heuristic* createHeuristic(DynamicRandomHeads*) {
  return new DynamicRandomHeads();
}
///////////////////////////////////////////////////////////////////////////////


RandomStrat::ValueType RandomStrat::Evaluate::operator()(Node* n, double) const {
  return rand() % 1024;
}


RandomHeadNodeStrat::ValueType RandomHeadNodeStrat::Evaluate::operator()(Node* n, double) const {
  return n->getType() == NodeType::head_node 
    ? rand() % 1024
    : 0;
}

}
