/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif
#include <operators/forward_prop.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#if defined (_MSC_VER) && _MSC_VER <= 1300
#define for if (0) ; else for
#endif

namespace NS_NOMORE { namespace {

///////////////////////////////////////////////////////////////////////////////
// returns false on conflict
bool propagateHeadSuccessors(Graph& g, HeadNode::BodyNodeIterator it, HeadNode::BodyNodeIterator end) {
  bool error = false;  
  for (; it != end && !error; ++it) {
    if((*it)->getColor() != Color::ignore) {
      if((*it)->isBlocked() || (*it)->isUnsupported()) {
        error = g.color(**it, Color::minus) == false;
      }
      else if( (*it)->isWeakSupported() && (*it)->isUnblocked() ) {
        error = g.color(**it, (*it)->recursiveSupportColor()) == false;
      }
    }
  }
  return !error;
}

// returns false on conflict
inline bool propagateBodySuccessors(Graph& g, const BodyNode& b, BodyNode::HeadNodeIterator it, BodyNode::HeadNodeIterator end) {
  bool error = false;
  for (; it != end && !error; ++it) {
    if (b.getColor() == Color::plus || b.getColor() == Color::weak_plus) {
      error = !g.color(**it, b.getColor());
    }
    else if ( (*it)->isUnsupported() ) {
      error = !g.color(**it, Color::minus);
    }
  }
  return !error;
}

} // end anonymous-namespace
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(ForwardPropagator*) {
  return "P";
}

template <>
Operator* createDetOp(Graph& g, ForwardPropagator*) {
  return new ForwardPropagator(g);
}
///////////////////////////////////////////////////////////////////////////////


ForwardPropagator::ForwardPropagator(Graph& grp) 
  : PropOperator(grp) {
  event::ChannelManager &em = grp.getEventManager();

  em.getChannelFor(event::Event<HeadNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).connect(*this);
  em.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).connect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).connect(*this);

}
ForwardPropagator::~ForwardPropagator() {
  event::ChannelManager &em = getGraph().getEventManager();
  em.getChannelFor(event::Event<HeadNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<BodyNodeColored>()).disconnect(*this);
  em.getChannelFor(event::Event<BodyNodeColoredChoicePoint>()).disconnect(*this);
  em.getChannelFor(event::Event<HeadNodeColoredChoicePoint>()).disconnect(*this);
}

const char* ForwardPropagator::getName() const {
  return NS_NOMORE::getName<ForwardPropagator>(0);
}

void ForwardPropagator::execute() {
  
  for (Graph& g = getGraph(); !g.hasConflict() && (!headsChanged_.empty() || !bodiesChanged_.empty()); ) {
    
    if (propagateHeadNodes())
      propagateBodyNodes();
    
  }

}

void ForwardPropagator::swapQueues(BodyQueue& bq, HeadQueue& hq) {
  bodiesChanged_.swap(bq);
  headsChanged_.swap(hq);
}

// returns false on conflict
bool ForwardPropagator::propagate(const HeadNode& h) {
  Graph& g = getGraph();
  bool ok = propagateHeadSuccessors(g, h.zeroSuccessorsBegin(), h.zeroSuccessorsEnd()) 
    && propagateHeadSuccessors(g, h.oneSuccessorsBegin(), h.oneSuccessorsEnd());
  return ok;
}

// returns false on conflict
bool ForwardPropagator::propagate(const BodyNode& b) {
  Graph& g = getGraph();
  bool ok = propagateBodySuccessors(g, b, b.successorsBegin(), b.successorsEnd());
  return ok;
  
}

// returns false on conflict
bool ForwardPropagator::propagateHeadNodes() {
  Graph& g = getGraph();
  for (HeadNode* n = 0; !headsChanged_.empty() && !g.hasConflict(); headsChanged_.pop()) {
    n = headsChanged_.front();
    assert(n);
    propagate(*n);
  }
  return g.hasConflict() == false;
}
 

bool ForwardPropagator::propagateBodyNodes() {
  Graph& g = getGraph();
  for (BodyNode* n = 0; !bodiesChanged_.empty() && !g.hasConflict(); bodiesChanged_.pop()) {
    n = bodiesChanged_.front();
    assert(n);
    propagate(*n);
  }
  
  return g.hasConflict() == false;
}


void ForwardPropagator::handle(const HeadNodeColored& e) {
  headsChanged_.push(e.node_);
}

void ForwardPropagator::handle(const BodyNodeColored& e) {
  bodiesChanged_.push(e.node_);
}

void ForwardPropagator::handle(const HeadNodeColoredChoicePoint& e) {
  headsChanged_.push(e.node_);
}

void ForwardPropagator::handle(const BodyNodeColoredChoicePoint& e) {
  bodiesChanged_.push(e.node_);
}


void ForwardPropagator::reset() {
  
  // note: do not use clear because this seems to be slower in some cases
  while ( !headsChanged_.empty() ) headsChanged_.pop();
  while ( !bodiesChanged_.empty() ) bodiesChanged_.pop();
  
}

}
