/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/lookahead.h>
#include <node.h>
#include <body_node.h>
#include <head_node.h>
#include <graph.h>
#include <heuristic.h>

namespace NS_NOMORE {

Lookahead::Lookahead(Graph& grp) 
  : PropOperator(grp)
  , operator_(0) 
  , ownsOperator_(true)
  , constraint_(0) {
}

Lookahead::Lookahead(Graph& grp, Operator& op, const Constraint& con) 
  : PropOperator(grp)
  , operator_(&op) 
  , ownsOperator_(false) 
  , constraint_(&con) {
}

Lookahead::~Lookahead() {
  if (ownsOperator_)
    delete operator_;
}

void Lookahead::setPropagationOperator(Operator& op) {
  if (ownsOperator_ && operator_ != &op)
    delete operator_;
  operator_ = &op;
  ownsOperator_ = false;
}

void Lookahead::setPropagationOperator(Operator* op, bool takeOverOwnership) {
  setPropagationOperator(*op);
  ownsOperator_ = takeOverOwnership;
}

bool Lookahead::checkColor(Node &node, Color::ColorValue color) {
  bool result = false;
  // color node as choice point -> a new stack is used
  if (getGraph().colorChoicePoint(node, color, Color::plus)) {
    ColorOpResult r = (*operator_)();
    result = r == ColorOperation::succeeded || r == ColorOperation::unchanged;
  }
  getGraph().restoreChoicePoint();
  return result;
}

bool Lookahead::color(Node &node, Color::ColorValue color) {
  if (getGraph().colorChoicePointStable(node, color)) {
    ColorOpResult r = (*operator_)();
    return r == ColorOperation::succeeded || r ==ColorOperation::unchanged;
  }
  else {
    return false;
  }
}

ColorOpResult Lookahead::operator()() {
  assert(constraint_ != 0);
  Graph& g = getGraph();
  
  g.getEventManager().dispatch(LookaheadExecution(ActivityState::started));

  ColorOpResult result = PropOperator::operator()();

  g.getEventManager().dispatch(LookaheadExecution(ActivityState::finished));

  return result;
  
}

Operator& Lookahead::getPropagationOperator() {
  return *operator_;
}

const Operator& Lookahead::getPropagationOperator() const {
  return *operator_;
}

}
