/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <operators/select_successors.h>
#include <graph.h>
#include <body_node.h>
#include <head_node.h>
namespace NS_NOMORE {


///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(SelectSuccessors*) {
  return "S";
}

template <>
ChoiceOperator* createChoiceOp(Graph& g, Heuristic* h, SelectSuccessors*) {
  return new SelectSuccessors(g, h);
}
///////////////////////////////////////////////////////////////////////////////
SelectSuccessors::SelectSuccessors(Graph& grp, Heuristic* h) 
  : ChoiceOperator(grp, h)
  , lastAction_(HeuristicValuesEvent::save) {
    event::ChannelManager& m = grp.getEventManager();
	  m.getChannelFor(event::Event<HeuristicValuesEvent>()).connect(*this);
}

Choice SelectSuccessors::selectChoice() {
  if(lastAction_ == HeuristicValuesEvent::save) {
    Choice node = getHeuristic().selectNode(*this);
    if(node.isValid()) {
      stack_.push(node.node());
    }
    return node;
  } 
  else if(lastAction_ == HeuristicValuesEvent::restore) {
    assert(!stack_.empty());
    Node *node = stack_.top();    
    Node *next = nextUncoloredNode(node);
    if(!next) {
      stack_.pop();
      lastAction_ = HeuristicValuesEvent::save;
    }
    return Choice(next);
  }
  assert(false);
  return Choice();
}

bool SelectSuccessors::isSatisfiedBy(const Node& n) const{
  return n.getColor() == Color::none;
}

Constraint::Type SelectSuccessors::getType() const {
  return Constraint::hybrid_constraint;
}

bool SelectSuccessors::supersedes(const Node& n1, const Node& n2) const {
  return true;
}

void SelectSuccessors::handle(const HeuristicValuesEvent &e) {
  lastAction_ = e.action_;  
}

Node* SelectSuccessors::nextUncoloredNode(const Node* n) const {
  Node* result = 0;
  if (n->getType() == NodeType::body_node) {
    const BodyNode* bn = static_cast<const BodyNode*>(n);
    BodyNode::HeadNodeIterator it = std::find_if(bn->successorsBegin(), bn->successorsEnd(), HasColor(Color::none));
    result =  it != bn->successorsEnd() ? *it : static_cast<HeadNode*>(0);
  }
  else {
    assert(n->getType() == NodeType::head_node);
    const HeadNode* hn = static_cast<const HeadNode*>(n);
    HeadNode::BodyNodeIterator it = std::find_if(hn->predecessorsBegin(), hn->predecessorsEnd(), HasColor(Color::none));
    result =  it != hn->predecessorsEnd() ? *it : static_cast<BodyNode*>(0);
  }
  return result;
}

const char* SelectSuccessors::getName() const {
  return NS_NOMORE::getName<SelectSuccessors>(0);
}

}
