/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef LIBNOMORE_RANDOM_HEURISTIC_H
#define LIBNOMORE_RANDOM_HEURISTIC_H
#include <static_heuristic.h>
#include <dynamic_heuristic.h>
#include <functional>
namespace NS_NOMORE {

//! Heuristic-Strategy that emulates random sorted rules.
/*! The heuristic values of all uncolored nodes set to random number between 0 and 1023.
 *
 *  \note Can be used with head and body nodes.
 *  \note This strategy may be used with either a Static- or a Dynamic-Heuristic. 
 */
class RandomStrat {
public:
  //! value type of the stategie
  typedef long ValueType; 

  //! the greater comparator
  typedef std::greater<ValueType> ComparatorType;

  //! sets the heuristic value for a node
  struct Evaluate {
    ValueType operator()(Node* n, double tf) const;
  };  

  //! evaluator type of the strategie
  typedef Evaluate EvaluatorType;
};

//! Heuristic-Strategy that emulates random sorted atoms.
/*! The heuristic values of all uncolored head nodes set to random number between 0 and 1023.
 *
 *  \note Can be used with head and body nodes.
 *  \note This strategy may be used with either a Static- or a Dynamic-Heuristic.
 */
class RandomHeadNodeStrat {
public:
  //! value type of the stategie
  typedef long ValueType; 

  //! the greater comparator
  typedef std::greater<ValueType> ComparatorType;

  //! sets the heuristic value for a node
  struct Evaluate {
    ValueType operator()(Node* n, double tf) const;
  };  

  //! evaluator type of the strategie
  typedef Evaluate EvaluatorType;
};

//! A static heuristic that uses RandomStrat as its strategy.
typedef StaticHeuristic<RandomStrat> StaticRandom;

//! A dynamic heuristic that uses RandomStrat as its strategy.
typedef DynamicHeuristic<RandomStrat> DynamicRandom;

//! A static heuristic that uses RandomHeadNodeStrat as its strategy.
typedef StaticHeuristic<RandomHeadNodeStrat> StaticRandomHeads;

//! A dynamic heuristic that uses RandomHeadNodeStrat as its strategy.
typedef DynamicHeuristic<RandomHeadNodeStrat> DynamicRandomHeads;

}
#endif
