/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         *
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         *
 ***************************************************************************/

#ifndef NOMORE_POST_OPERATOR_H
#define NOMORE_POST_OPERATOR_H

#include <operator.h>
#include <color.h>

#include <utility>

namespace NS_NOMORE {

class BodyNode;
class HeadNode;

//! Operator used to totalize a \ref NS_NOMORE::Graph "graph".
/*!
 *  \deprecated This operator is deprecated. It will be removed in the next
 * release. Don't use this operator. Call the graph's totalize method
 * instead.
 *
 *  The post operator (also called \c N-operator) colors all uncolored nodes
 *  (heads and bodies) to minus. This operation is reasonable only if no other operator
 *  is able to color them. For example the \ref ForwardPropagator "forward propagator" and
 *  \ref BackwardPropagator "backward propagator" can not always decide whether a
 *  positve (zero) loop must be colored \ref Color::plus "plus" or
 *  \ref Color::minus "minus".
 *
 *  <b>Q: When do I need to use the post processing operator</b>?
 *	<b>A:</b> Whenever you do not use a maximal support operator.
 *	For example, if you only use the \ref ForwardPropagator "forward propagator" and
 *  \ref BackwardPropagator "backward propagator" you must use the post processing
 *  operator that decides positive (zero) loops.
 *
 *  <b>Q: How does the operator work?</b>
 *	<b>A:</b> The operator inspects all head- and body nodes of the graph.
 *	Nodes that are still \ref Color::none "uncolored" are colored to Color::minus "minus".
 *	If a node with color Color::weak_plus "weak plus" is found, a \ref ColorError
 *	"ColorError exception" is thrown.
 *
 *	\note This operator does not verify if changing the color of
 *	an \ref Color::none "uncolored" to Color::minus "minus" is valid.
 *	This has to be done in a seperate propagation step (for example using
 *	the \ref ForwardPropagator "forward propagator")
 */
class PostOperator : public Operator {
public:
  //! Creates the operator.
  /*! \param grp The graph the operator should work on. */
  PostOperator(Graph& grp);

  //! returns true if ops contains neither U nor V
  bool validate(const OpSet& ops) const;

  //! Returns the name of the operator.
  const char* getName() const;

  ColorOpResult operator()();
private:
  Graph* graph_;
};

}

#endif
