/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_NARY_BACKTRACKING_SOLVER_H
#define NOMORE_NARY_BACKTRACKING_SOLVER_H

#include <solver.h>
#include <memory>

namespace NS_NOMORE {
//! Nomore's answer set solver.
class NaryBacktrackingSolver : public Solver {
public:
  NaryBacktrackingSolver();
  
  /*! 
   * \param as Maximal number of answer sets to compute (0=all answer sets).
   * \param det Deterministic operators for propagation.
   * \param look Lookahead operator for propagation (0 to indicate no lookahead).
   * \param choice Choice operator for selecting nodes.
   * \param printer Printer instance to be used for printing answer sets.
   *
   * \pre pointer arguments are either != 0 and point to objects that were
   * allocated using new or 0.
   *
   * \pre choice->extractOperator(choice->getName()) returns an operator 
   * that can be downcasted to ChoiceOperator
   *
   * \note the Solver takes over ownership of the objects
   */
  NaryBacktrackingSolver(int as, Operator *det, Operator* look, Operator *choice, Printer *printer);

private:
  bool backtrack(Graph& g);
  ColorOpResult choose(Graph& g);
  ChoiceOperator* choiceOp_;
};
}

#endif
