/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#ifndef NOMORE_SELECT_SUCCESSORS_OPERATOR_H
#define NOMORE_SELECT_SUCCESSORS_OPERATOR_H

#include <choice_operator.h>
#include <heuristic.h>
#include <stack>

namespace NS_NOMORE {

class BodyNode;
class HeadNode;

//! 
class SelectSuccessors : public ChoiceOperator {
public:
  //! Creates the choice operator.
  /*! \param grp The graph the operator should work on. 
   *  \param h The heuristics for choosing a node. */ 
  SelectSuccessors(Graph& grp, Heuristic* h);

  Choice selectChoice();
  
  Constraint::Type getType() const;

  //! Returns the name of the operator.
  const char* getName() const;

  virtual const Constraint& getConstraint() const;
  void handle(const HeuristicValuesEvent &e);

private:  
  Node* nextUncoloredNode(const Node* bn) const;

  typedef std::stack<Node*> Stack;
  
  Stack stack_;
  HeuristicValuesEvent::Action lastAction_;
  NoConstraint c_;
};

}

#endif
