// Hash set
// Copyright (c) Benjamin Kaufmann
// Adapted from SGI's hash_set (see copyright notice at end of file)
#ifndef UTIL_HASH_SET_H_INCLUDED
#define UTIL_HASH_SET_H_INCLUDED
#if defined (_MSC_VER) && _MSC_VER <= 1200
#pragma warning (disable : 4786)
#endif
#include "hash_fun.h"
#include "hash_helper.h"
namespace util {

// a simple hash set using seperate chaining
template <
	class Key, 
	class HashPred = Hash<Key>, 
	class EqualPred = std::equal_to<Key>
>
class hash_set
{
	typedef detail::hash_common<Key, Key, HashPred, EqualPred, detail::Identity<Key> > impl_type;
public:
	typedef Key key_type;
    typedef Key value_type;
	typedef HashPred hasher_type;
	typedef EqualPred key_compare;
	typedef size_t	size_type;
	typedef ptrdiff_t difference_type;
	typedef const key_type* pointer;
	typedef const key_type* const_pointer;
	typedef const key_type& reference;
	typedef const key_type& const_reference;
	
	typedef typename impl_type::const_iterator const_iterator;
	typedef typename impl_type::const_iterator iterator;

	explicit hash_set(	size_type initialCapacity = 100,
						float loadFactor = 0.75f,
						const HashPred& hf = HashPred(), 
						const EqualPred& ef = EqualPred())
		: impl_(initialCapacity, 
				((loadFactor > 0 && loadFactor <= 1.0f) ? loadFactor : 0.75f),
				hf, ef, detail::Identity<Key>())
	{}
	
	template <class Iter>
	hash_set(Iter first, Iter last, 
			 size_type initialCapacity = 100, 
			 float loadFactor = 0.75f,
			 const HashPred& hf = HashPred(), 
			 const EqualPred& ef = EqualPred())
		: impl_(initialCapacity, 
				((loadFactor > 0 && loadFactor <= 1.0f) ? loadFactor : 0.75f),
				hf, ef, detail::Identity<Key>())
	{
		impl_.insert(first, last);
	}
	
	~hash_set()
	{
		clear();
	}

	size_type count(const key_type& k) const
	{
		return impl_.count(k);
	}

	void swap(hash_set& other)
	{
		impl_.swap(other.impl_);
	}

	std::pair<iterator, bool> insert(const value_type& x)
	{
		return impl_.insert(x);
	}
	
	template <class Iter>
	void insert(Iter first, Iter last)
	{
		impl_.insert(first, last);
	}

	const_iterator find(const key_type& key) const
	{
		return impl_.find(key);
	}
	
	size_type erase(const key_type& key)
	{
		return impl_.erase(key);
	}
	
	void erase(iterator it)
	{
		impl_.erase(it);
	}
	
	void erase(iterator first, iterator last)
	{
		impl_.erase(first, last);
	}
	
	void clear()
	{
		impl_.clear();
	}

	iterator begin()
	{
		return impl_.begin();
	}
	
	const_iterator begin() const
	{
		return impl_.begin();
	}
	
	iterator end()
	{
		return impl_.end();
	}
	
	const_iterator end() const
	{
		return impl_.end();
	}

	size_type size() const 
	{
		return impl_.size();
	}
	size_type max_size() const
	{
		return impl_.max_size();
	}
	bool empty() const
	{
		return impl_.empty();
	}
private:
	impl_type impl_;
};

}

/*
 * Copyright (c) 1996-1998
 * Silicon Graphics Computer Systems, Inc.
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Silicon Graphics makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 *
 * Copyright (c) 1994
 * Hewlett-Packard Company
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation.  Hewlett-Packard Company makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#endif
