/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

#include <heuristic.h>
#include <graph.h>
#include <algorithm>

namespace NS_NOMORE {

///////////////////////////////////////////////////////////////////////////////
template <>
const char* getName(SelectFirst*) {
  return "None";
}

template <>
Heuristic* createHeuristic(SelectFirst*) {
  return new SelectFirst();
}
///////////////////////////////////////////////////////////////////////////////

Heuristic::Heuristic() : graph_(0), channel_(0) {}
Heuristic::~Heuristic() {}
void Heuristic::setGraph(Graph& g) {
  graph_ = &g; 
  channel_ = &graph_->getEventManager().getChannelFor(event::Event<HeuristicExecution>());
  doSetGraph();
}

void Heuristic::doSetGraph() {}
void Heuristic::setPropagationOperator(Operator&) {}

Choice Heuristic::selectNode(const Constraint& c) {
  channel_->dispatch(HeuristicExecution(ActivityState::started));
  Choice choice = doSelectNode(c);
  channel_->dispatch(HeuristicExecution(ActivityState::finished));
  return choice;
}
  
SelectFirst::SelectFirst() {}

Choice SelectFirst::doSelectNode(const Constraint& c) {
  for (Graph::UncoloredNodeIterator it = getGraph().uncoloredNodesBegin(); it != it.end(); ++it) {
    if (c.isSatisfiedBy(**it)) {
      return Choice(*it);
    }
  }
  return Choice();
}

const char* SelectFirst::getName() const {
  return NS_NOMORE::getName<SelectFirst>(0);
}

}

