#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <heuristics/static_lex_ordering.h>
#include <operators/hybrid_lookahead.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class LexOrderingTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(LexOrderingTest);
  CPPUNIT_TEST(testSimpleOrderCheck);
  CPPUNIT_TEST(testCheck1);
  CPPUNIT_TEST(testCheck2);
  CPPUNIT_TEST(testCheck3);
  CPPUNIT_TEST_SUITE_END();

public:
  void setUp() {
    graph = new Graph;
    body1 = graph->insertBodyNode();
    body2 = graph->insertBodyNode();
    body3 = graph->insertBodyNode();
    
    head1 = graph->insertHeadNode(1);
    head2 = graph->insertHeadNode(2);
    head3 = graph->insertHeadNode(3);
    head4 = graph->insertHeadNode(4);
    heu = new LexOrdering();
    heu->setGraph(*graph);
  }

  void tearDown() {
    delete graph;
    delete heu;
  }

  void testSimpleOrderCheck() {
    std::string s1 = "x, y";
    std::string s2 = "x1";
    CPPUNIT_ASSERT_EQUAL(true, s1 < s2);
  }

  void testCheck1() {

    head1->insertZeroSuccessor(*body1);
    head3->insertOneSuccessor(*body1);

    head1->insertZeroSuccessor(*body2);
    head2->insertZeroSuccessor(*body2);
    head4->insertOneSuccessor(*body2);

    head1->insertZeroSuccessor(*body3);
    head4->insertOneSuccessor(*body3);

    head1->setAtomName("a");
    head2->setAtomName("b");
    head3->setAtomName("x");
    head4->setAtomName("y");
    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body1, heu->selectNode(OnlyBodies()).node() );
  }

  void testCheck2() {
    head1->insertZeroSuccessor(*body1);
    head4->insertOneSuccessor(*body1);

    head2->insertZeroSuccessor(*body2);
    head1->insertZeroSuccessor(*body2);
    head3->insertOneSuccessor(*body2);

    head3->insertZeroSuccessor(*body3);
    head4->insertOneSuccessor(*body3);

    head1->setAtomName("b");
    head2->setAtomName("a");
    head3->setAtomName("c");
    head4->setAtomName("x");
    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body2, heu->selectNode(OnlyBodies()).node() );
  }

  void testCheck3() {
    head1->insertZeroSuccessor(*body1);
    head3->insertOneSuccessor(*body1);

    head2->insertZeroSuccessor(*body2);
    head3->insertOneSuccessor(*body2);

    head4->insertOneSuccessor(*body3);

    head1->setAtomName("a");
    head2->setAtomName("b");
    head3->setAtomName("c");
    head4->setAtomName("d");
    graph->finishConstruction();
    CPPUNIT_ASSERT_EQUAL( (Node*)body3, heu->selectNode(OnlyBodies()).node() );
  }

private:
  BodyNode* body1;
  BodyNode* body2;
  BodyNode* body3;
  
  HeadNode* head1;
  HeadNode* head2;
  HeadNode* head3;
  HeadNode* head4;
  Graph* graph;
  LexOrdering *heu;
};

CPPUNIT_TEST_SUITE_REGISTRATION(LexOrderingTest);

} // end namespace NS_NOMORE_TESTS
