/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_NULL_PRINTER_H
#define NOMORE_NULL_PRINTER_H

#include <printer.h>

namespace NS_NOMORE {

//! Does not print answer sets.
/*! 
 *  The NullPrinter is useful in benchmark environments where only the raw 
 *  computing performance is interesting, not the time spent writing to some 
 *  output device.
 * 
 *  \see The Null Object Pattern http://c2.com/cgi/wiki?NullObject */
class NullPrinter : public Printer {
public:
  //! Constructs the object.
  NullPrinter() {}

private:
  // instance methods
  void print(int nr, const Graph& g);
};

}

#endif
