/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_STOUT_PRINTER_H
#define NOMORE_STOUT_PRINTER_H

#include <printer.h>

namespace NS_NOMORE {

//! Writes answer sets to stdout.
/*! 
 *  Use this class to write all plus colored head nodes (the name of the atoms 
 *  corresponding to the head node) to stdout in a format similar to smodels 
 *  or nomore++ v1.0.
 *
 *  The output looks like:
 *  \code
 *  Answer: 1
 *  a b d e d
 *  \endcode
 *  where <b>a</b>, <b>b</b>, <b>d</b>, <b>e</b> and <b>d</b> are atoms which 
 *  are colored plus in the graph. */
class StdoutPrinter : public Printer {
public:
  //! Constructs the object.
  StdoutPrinter() {}

private:
  // instance methods
  void print(int nr, const Graph& g);
};

}

#endif
