/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_TIMING_STATISTICS_H
#define NOMORE_TIMING_STATISTICS_H

#include <statistics/statistics_object.h>
#include <statistics/timer.h>

namespace NS_NOMORE {

class Graph;
struct LookaheadExecution;
struct HeuristicExecution;
struct GraphConstructionFinished;

//! Gathering timing informations of some parts of the computation.
/*! 
 *  The following informations are gathered (all values in percent) :
 *    - time of graph construction
 *    - time of lookahead execution
 *    - time of node selection/heuristics
 *    - time of normal propagation */
class TimingStatistics : public StatisticsObject {
public:
  //! Init timer counters and register at desired channels.
  /*! 
   *  \param m Channel manager for registering at desired channels. */
  TimingStatistics(event::ChannelManager& m);

  //! Cleans up the instance.
  virtual ~TimingStatistics();

  //! Prints the timing result to a stream.
  /*!
   *  \param os The output stream to write the timing stats to. */
  void print(std::ostream& os) const;
  
  //! Event handler for LookaheadExecution events.
  /*!
   *  \param e The raised event. */
  void handle(const LookaheadExecution& e);

  //! Event handler for HeuristicExecution events.
  /*!
   *  \param e The raised event. */
  void handle(const HeuristicExecution& e);

  //! Event handler for GraphConstructionFinished events.
  /*!
   *  \param e The raised event. */
  void handle(const GraphConstructionFinished& e);

private:
  // instance methods
  void registerWith(event::ChannelManager& m);

  // instance variables
  uint64 startGraphConstruction_;
  uint64 endGraphConstruction_;
  uint64 graphConstruction_;

  uint64 startPropagation_;
  uint64 endPropagation_;
  uint64 propagation_;

  uint64 startLookahead_;
  uint64 endLookahead_;
  uint64 lookahead_;

  uint64 startHeuristic_;
  uint64 endHeuristic_;
  uint64 heuristic_;

  uint64 startExecution_;
  uint64 endExecution_;
  uint64 execution_;
};

}

#endif
