/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#include <stats.h>
#include <iomanip>
#include <cassert>

namespace NS_NOMORE {

Statistics::Statistics() :  sec_(0), msec_(0) {
}

Statistics::~Statistics() {
  for(unsigned int i = 0; i < statistics_.size(); ++i)
    delete statistics_[i];
}

void Statistics::startTimer() {
  timer_ = clock();
}
  
void Statistics::stopTimer() {
  clock_t ticks = clock () - timer_;
  long s = ticks / CLOCKS_PER_SEC;
  sec_ += s;
  msec_ += (ticks - s*CLOCKS_PER_SEC)*1000/CLOCKS_PER_SEC;
  if (msec_ >= 1000) {
    msec_ -= 1000;
    sec_++;
  }
}

void Statistics::add(StatisticsObject* stats) {
  assert(0 != stats);
  statistics_.push_back(stats);
}

void Statistics::print(std::ostream& os) const {
  os << "Time: " << sec_ << '.' << std::setw(3) << std::setfill('0') << msec_ << std::endl;  

  for(unsigned int i = 0; i < statistics_.size(); ++i)
    statistics_[i]->print(os);
}

}
