/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef LIBNOMORE_CONSTRAINT_H
#define LIBNOMORE_CONSTRAINT_H

#if defined (_MSC_VER) && _MSC_VER <= 1300
#pragma warning (disable : 4786)
#endif

namespace NS_NOMORE {

class Node;

//! A constraint checks whether a node satisfies some condition.
class Constraint {
public:
  //! Type of constraints
  enum Type {
    //! A uniform constraint works only for head or body nodes.
    uniform_constraint, 
    
    //! A bybrid constraint works for head and body nodes.
    hybrid_constraint
  };
  
  //! Constructs the constraint.
  Constraint();

  //! Destroys the constraint.
  virtual ~Constraint();

  //! Returns true if the given node satisfies this constraint.
  /*!
   *  \param n The node tested for satisfying the constraint.
   *  \return True if n satisfies the constraint. */
  virtual bool isSatisfiedBy(const Node& n) const = 0;

  //! Returns true if node n2 supersedes node n1 for the corresponding constraint.
  /*!
   *  \param n1 The first node.
   *  \param n2 The second node.
   *  \return True if n2 supersedes n1. */
  virtual bool supersedes(const Node& n1, const Node& n2) const = 0;

  //! Returns the type of the constraint.
  /*!
   *  \return The type of the constraint. 
   *
   *  \see Constraint::Type */
  virtual Type getType() const = 0;
  
private:
  // deny constructors
  Constraint(const Constraint&);
  Constraint& operator=(const Constraint&);
};

}

#endif
