/***************************************************************************
 *                                                                         *
 *    NoMoRe++                                                             *
 *                                                                         *
 *    Copyright (C) 2003-2005 NoMoRe Developing Group                      *
 *                                                                         * 
 *    For more information, see http://www.cs.uni-potsdam.de/nomore/       *
 *    or email to nomore-dg@cs.uni-potsdam.de                              *
 *                                                                         *
 *                                                                         *
 *    This program is free software; you can redistribute it and/or        *
 *    modify it under the terms of the GNU General Public License          *
 *    as published by the Free Software Foundation; either version 2       *
 *    of the License, or (at your option) any later version.               *
 *                                                                         *
 *    This program is distributed in the hope that it will be useful,      *
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *    GNU General Public License for more details.                         *
 *                                                                         *
 *    You should have received a copy of the GNU General Public License    *
 *                                                                         * 
 ***************************************************************************/
#ifndef NOMORE_SELECT_SUCCESSORS_OPERATOR_H
#define NOMORE_SELECT_SUCCESSORS_OPERATOR_H

#include <choice_operator.h>
#include <heuristic.h>

#include <stack>

namespace NS_NOMORE {

class BodyNode;
class HeadNode;

//! Choice operator selecting a node and its predecessors or successors as choice.
/*!
 *  This choice operator is implemented for the n-ary backtracking search. 
 *  First the algorithm selects the best node n according to the heuristics 
 *  and colors it which the preferred color. After backtracking the successors 
 *  (if n is a body node) or predecessors (if n is a head node) are selected as
 *  choice. 
 *
 *  \note This operator is only useful with the n-ary backtracking solver. It
 *        also returns valid results for binary backtracking solver. */
class SelectSuccessors : public ChoiceOperator {
public:
  //! Creates the choice operator.
  /*!  
   *  \param grp The graph the operator should work on. 
   *  \param h The heuristics for choosing a node. */ 
  SelectSuccessors(Graph& grp, Heuristic* h);

  //! Selects a choice point.
  /*! 
   *  Returns a choice object containing the node to be colored as choice 
   *  point as well the choice's preferred and alternative choice color. 
   *
   *  \return The choice which is made using the heuristics. */
  Choice selectChoice();
  
  //! Returns the type of the constraint.
  /*!
   *  \return Constraint::Type::hybrid_constraint. 
   *
   *  \see Constraint::Type */
  Constraint::Type getType() const;

  //! Returns the name of the choice operator.
  /*!
   *  \return The name of the choice operator. */
  const char* getName() const;

  //! Returns the constraint used to select the best node.
  /*! 
   *  \return The constraint to select any uncolored node. 
   *  \see NoConstraint */
  virtual const Constraint& getConstraint() const;

  //! Event handler for HeuristicValuesEvent events.
  /*!
   *  \param e The raised event. */
  void handle(const HeuristicValuesEvent &e);

private:  
  // typedefs
  typedef std::stack<Node*> Stack;

  // instance methods
  Node* nextUncoloredNode(const Node* bn) const;
  
  // instance variables
  HeuristicValuesEvent::Action lastAction_;
  NoConstraint c_;
  Stack stack_;
};

}

#endif
