#include <cppunit/TestFixture.h>
#include <cppunit/TestAssert.h>
#include <cppunit/extensions/HelperMacros.h>
#include <choice_operator.h>
#include <heuristic.h>
#include <graph.h>
#include "test_common.h"
using namespace NS_NOMORE;

namespace NS_NOMORE_TESTS {

class ChoiceOpTest : public CppUnit::TestFixture {

  CPPUNIT_TEST_SUITE(ChoiceOpTest);
  CPPUNIT_TEST(testSuccess);
	CPPUNIT_TEST(testNoChoiceLeft);
	CPPUNIT_TEST_SUITE_END();

public:
	void setUp() {
		node = g.insertBodyNode();
		cp = new FakeCpOp(g);
	}
	void tearDown() {
		delete cp;
	}
	void testSuccess() {
		cp->setChoiceNode(node);
		CPPUNIT_ASSERT_EQUAL(true, (*cp)());
		CPPUNIT_ASSERT_EQUAL(node->preferredChoicePointColor(), node->getColor());
	}

	void testNoChoiceLeft() {
		cp->setChoiceNode(0);
		CPPUNIT_ASSERT_EQUAL(false, (*cp)());
	}
private: 
	class FakeCpOp : public ChoiceOperator {
	public:
		FakeCpOp(Graph& g) : ChoiceOperator(g, new SelectFirst), cp_(0) {}
		void setChoiceNode(Node* n) {cp_ = n;}
		Choice selectChoice() {
			return Choice(cp_);
		}
		const char* getName() const { return "FakeCP"; }
		const Constraint& getConstraint() const { return con; }
	private:
		Node* cp_;
		NoConstraint con;
	};

	Graph g;
	BodyNode* node;
	FakeCpOp* cp;
};

CPPUNIT_TEST_SUITE_REGISTRATION(ChoiceOpTest);

} // end namespace NS_NOMORE_TESTS
