/***************************************************************************
                          algorithm.h  -  description
                             -------------------
    begin                : Mon Aug 23 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ALGORITHM_H
#define ALGORITHM_H

#include "cdetoperator.h"
#include "cndoperator.h"
#include "cgraph.h"

namespace NS_NOMORE {


//! Generates the aggregation tree out of the input string
/*! \param op Input string which specifies the operators ("Pre:Choice:Det:Closure")
    \param det_out Deterministic output operator
    \param pre_out Deterministic output operator
    \param ndet_out Non-deterministic output operator
    \return if the input string syntax is ok and the operators are created the methode return true else false*/
	bool GenerateOperator(string op, CDetOperator*& det_out,
																	 CDetOperator*& pre_out,
																	 CNdOperator*& ndet_out,
																	 CDetOperator*& end_out, bool todo, bool prefs);


	//! generate admissible colorings for graphs and put the corresponding answer set to stdout
	/*! \param graph Graph which should be colored for computing answer sets (last coloring is returned)
  	  \param op String which contains the non-deterministic operator and the deterministic operators
    	\param as_count Number of answer sets to search (0 means all answer sets)*/
	bool ColorGraph(CGraph* graph, string op, int as_count, bool todo, bool prefs);


} // end of namespace NS_NOMORE

#endif
