/***************************************************************************
                          cgraph.cpp  -  description
                             -------------------
    begin                : Mon Aug 23 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cgraph.h"
#include "cprogram.h"
#include "cnode.h"
#include "crule.h"
//#include "coperator.h"
//#include "caggregation.h"
#include "print.h"

#include <iostream>

using namespace std;

namespace NS_NOMORE {

/**********************************************************************************************************
  class CGraph
**********************************************************************************************************/
CGraph::CGraph(){
	_pnodes = new TNodeSet;
  _count_is_total = 0;

  CREATEOBJECT("CGraph")
}



CGraph::CGraph(CProgram* prg) {
	_pnodes = new TNodeSet;
  _count_is_total = 0;

  CREATEOBJECT("CGraph")

  CHECK_POINTER("CGraph::CGraph(CProgram*)", prg);

  TRuleSet* rules = prg->GetRules();
	CHECK_POINTER("CGraph::CGraph(CProgram*)", rules);
	CreateNodes(rules);

	TSetOfRuleSet *ruleset = prg->GetAtomsAndRules();
	CHECK_POINTER("CGraph::CGraph(CProgram*)", ruleset);	
	HandleEdges(ruleset);
  HandleNegCompute(prg->GetBMinus());
}

CGraph::~CGraph(){
	TNodeSet::iterator ite;
	for (ite=_pnodes->begin();ite!=_pnodes->end();ite++)
		if ((*ite).second)
			delete (*ite).second;

	delete _pnodes;
  DELETEOBJECT("CGraph")
}

bool CGraph::operator==(const CGraph& graph) {
	return *_pnodes==*graph._pnodes;
}

bool CGraph::operator!=(const CGraph& graph){
	return !(operator==(graph));
}


//! creates a new node for every rule and inserts it in _pnodes
void CGraph::CreateNodes(TRuleSet* rules) {
  CHECK_POINTER("CGraph::CreateNodes()", rules);
  TRuleSet::iterator ite;

  for(ite=rules->begin();ite!=rules->end();ite++){
    CNode* node = this->GenerateNode(ite->second);
    InsertNode(node);
  }
}


CNode* CGraph::GenerateNode(CRule *rule) const {
		CNode *node = new CNode(rule->GetId());
		node->SetRule(rule);
    return node;
}


void CGraph::HandleEdges(TSetOfRuleSet* ruleset) {
  TNodeSet::iterator ite1;
//  ite1=_pnodes->find(11);
  int b=_pnodes->size();
//  cout<<*this<<endl;
//  if (ite1 != _pnodes->end()) cout<<*ite1->second<<endl;
	for (ite1=_pnodes->begin();ite1!=_pnodes->end();ite1++) {
		CNode *node = ite1->second;
    TId id = node->GetId();
//    string name = node->GetRule()->GetHeads()->begin()->second->GetName();
    if (node ==NULL) cout<<"node is null"<<endl;
		TAtomSet *pbody = (node->GetRule())->GetpBody();
		TAtomSet *nbody = (node->GetRule())->GetnBody();
		TAtomSet::iterator ite2;
		for (ite2=pbody->begin();ite2!=pbody->end();ite2++) {
			TRuleSet *rules = (*ruleset)[ite2->first];
			if (rules == NULL) {
//				node->InsertZeroPredecessor(new CNode((TId)0));
			}
			else {
				TRuleSet::iterator ite3;
				for (ite3=rules->begin();ite3!=rules->end();ite3++) {
					CNode *node1 = (*_pnodes)[ite3->first];
					node->InsertZeroPredecessor(node1);
					node1->InsertZeroSuccessor(node);
				}
			}
		}
		for (ite2=nbody->begin();ite2!=nbody->end();ite2++) {
			TRuleSet *rules = (*ruleset)[ite2->first];
			TRuleSet::iterator ite3;
			if (rules != NULL)
				for (ite3=rules->begin();ite3!=rules->end();ite3++) {
					CNode *node2 = (*_pnodes)[ite3->first];
					node->InsertOnePredecessor(node2);
					node2->InsertOneSuccessor(node);
				}
		}
	}
}


void CGraph::HandleNegCompute(TAtomSet* atoms) {
  TAtomSet::iterator ite1;
  TNodeSet::iterator ite2;
  TStack stack;
  for (ite1=atoms->begin();ite1!=atoms->end();ite1++) {
    //    string a = ite1->second->GetName();
    for (ite2=_pnodes->begin();ite2!=_pnodes->end();ite2++) {
      TId id = ite2->second->GetId();
      //      string name = ite2->second->GetRule()->GetHeads()->begin()->second->GetName();
      if (ite2->second->GetRule()->GetHeads()->begin()->first == ite1->first)      
        ColorNode(ite2->second,color_minus,&stack,false,color_none);
//        ite2->second->SetColor(color_minus);
//        _count_is_total--;
    }
  }
}

bool CGraph::InsertNode(CNode *node) {
	CHECK_POINTER("CGraph::InsertNode()", node);
	(*_pnodes)[node->GetId()] = node;
	_count_is_total++;
	return true;
}

TAtomSet* CGraph::GetAnswerSet() {
	TAtomSet *answerset = new TAtomSet;
	TNodeSet::iterator ite;
	for (ite=_pnodes->begin();ite!=_pnodes->end();ite++) {
		CNode *node = (*ite).second;
		if (node->GetColor() == color_plus) {
			TAtomSet *atoms = (node->GetRule())->GetHeads();
			TAtomSet::iterator ite2;
			for (ite2 = atoms->begin();ite2 != atoms->end(); ite2++) {
				CAtom *atom = (*ite2).second;
				(*answerset)[atom->GetId()] = atom;
			}
		}
	}
	return answerset;
}


bool CGraph::ColorNode(CNode *node, TColor color, TStack *stack, bool choice_point, TColor choice_color) {
	CHECK_POINTER("CGraph::ColorNode() node", node);
	CHECK_POINTER("CGraph::ColorNode() stack", stack);

  if (!node->ColorNode(color,stack,choice_point,choice_color))
		return false;

	if ((color == color_plus) || (color == color_minus))
		_count_is_total--;
	return true;
}


bool CGraph::LoadState(CNode *node, char* rhs, unsigned long& size) {
  CHECK_POINTER("CGraph::LoadState() node", node);
  CHECK_POINTER("CGraph::LoadState() rhs", rhs);

  TColor old = node->GetColor();

  if (!node->LoadState(rhs,size))
		return false;

//	if ((old != color_must_be_minus) && (old != color_was_plus))
	if ((old == color_plus) || (old == color_minus))
		_count_is_total++;
	return true;
}


bool CGraph::TotalColoring(){
  INC_COUNT(methode_totalcoloring);
  START_TIMER(methode_totalcoloring_time);
  STOP_TIMER(methode_totalcoloring_time);
  int i=_count_is_total;
	return (_count_is_total <= 0);
}


void WriteColoring(CGraph* graph){
	CHECK_POINTER("WriteColoring()", graph);

	TNodeSet *nodes = graph->GetNodes();
  TNodeSet::iterator ite;

  std::cout << "Plus-Colored  : ";

  for(ite=nodes->begin();ite!=nodes->end();ite++)
		if (ite->second->GetColor() == color_plus) 
	    std::cout << ite->second->GetRule()->GetHeads()->begin()->second->GetName() << " ";

	nodes = graph->GetNodes();
  std::cout << std::endl << "Minus-Colored : ";

  for(ite=nodes->begin();ite!=nodes->end();ite++){
		if (ite->second->GetColor() == color_minus) 
	    std::cout << ite->second->GetRule()->GetHeads()->begin()->second->GetName() << " ";
  }

  std::cout << std::endl;
}

} // end of namespace NS_NOMORE

