/***************************************************************************
                          cgraph.h  -  description
                             -------------------
    begin                : Mon Aug 23 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file cgraph.h
		Contains Definitions of CGraph */

#ifndef CGRAPH_H
#define CGRAPH_H

#include <iostream>
#include "misc.h"
#include "cnode.h"

namespace NS_NOMORE {

class CProgram;

/*! \class CGraph
		\brief Defines the graph which consists of simple nodes. */

class CGraph {
	//! Output operator
	friend std::ostream& operator<<(std::ostream& os, CGraph& graph);

protected:
	TNodeSet *_pnodes; //!< The nodes of the graph.

	int _count_is_total;

protected:
	//! Creates Nodes from a rule set
	void CreateNodes(TRuleSet*);

	//! Insert predecessor and successor information
	void HandleEdges(TSetOfRuleSet*);

  void HandleNegCompute(TAtomSet*);

public:
	CGraph();

  //! Constructor initializes the graph by a program
	CGraph(CProgram* prg);

	//! Destructor
	virtual ~CGraph();

  //! Returns the type of the graph
  virtual TType GetType() const {
    return type_cgraph;
  }

  //! Equality Operator
	bool operator==(const CGraph& graph);

	//! Inequality Operator
	bool operator!=(const CGraph& graph);

	//! Returns the set of nodes of the graph.
	inline TNodeSet* GetNodes(){
	  return _pnodes;
  }

	//! Returns the answer set corresponding to the colored graph. This answer set must be generated before.
	TAtomSet* GetAnswerSet();

	//! Inserts a node into the graph.
  /*! \param node Node which is copied into the set of node with their id
      \return true*/
	virtual bool InsertNode(CNode *node);

  //! Returns true if all nodes are not colored with color_none
  virtual bool TotalColoring();

  //! Colors a node and handles lists _puncolored etc.
  virtual bool ColorNode(CNode *node, TColor color, TStack *stack, bool choice_point, TColor choice_color);

  //! Colors a node and handles lists _puncolored etc.
  virtual bool LoadState(CNode *node, char* rhs, unsigned long& size);

	//! Builds Answer Set. Generic, needs to be overwritten by child.
//	virtual bool BuildAnswerSet();

	//! Generates a node
	virtual CNode* GenerateNode(CRule*) const;

	inline int GetCountIsTotal() {
		return _count_is_total;
	}

	inline void DecCountIsTotal() {
		_count_is_total--;
	}

	inline void IncCountIsTotal() {
		_count_is_total++;
	}

};

void WriteColoring(CGraph* graph);

} // end of namespace NS_NOMORE


#endif
