/***************************************************************************
                          cgraphpref.cpp  -  description
                             -------------------
    begin                : Wed Sep 1 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "cgraphpref.h"
#include "cprogram.h"
#include "cnode.h"
#include "crule.h"
#include "coperator.h"
#include "caggregation.h"
#include "print.h"

#include <iostream>

using namespace std;

namespace NS_NOMORE {

/**********************************************************************************************************
  class CGraphPref
**********************************************************************************************************/
/*CGraphPref::CGraphPref() : CGraph(){
	_pmust_be_minus = new TNodeSet;

  CREATEOBJECT("CGraphPref")
} */

CGraphPref::CGraphPref(CProgram* prg) : CGraph() {
	_pmust_be_minus = new TNodeSet;

  CREATEOBJECT("CGraphPref")

  TRuleSet* rules = prg->GetRules();

	CHECK_POINTER("CGraph::CGraph(CProgram*)", rules);
	CreateNodes(rules);
	TSetOfRuleSet *ruleset = prg->GetAtomsAndRules();
	CHECK_POINTER("CGraph::CGraph(CProgram*)", ruleset);
	HandleEdges(ruleset);
	HandleNegCompute(prg->GetBMinus());
	HandlePreferences(rules,prg->GetPrefs(),prg->GetAtoms());
}

CGraphPref::~CGraphPref(){
	delete _pmust_be_minus;
  DELETEOBJECT("CGraphPref")
}

bool CGraphPref::operator==(const CGraphPref& graph) {
	return CGraph::operator==(graph);
}

bool CGraphPref::operator!=(const CGraphPref& graph) {
	return !(*this==(graph));
}


//creates a new node for every rule and inserts it in _pnodes and _puncolored
void CGraphPref::CreateNodes(TRuleSet* rules) {
  CHECK_POINTER("CGraph::CreateNodes()", rules);
  TRuleSet::iterator ite;
  // first generate all nodes with id of the corresponding rule
  for(ite=rules->begin();ite!=rules->end();ite++){
  	CRule* rule = ite->second;

    // create node
    TId id = rule->GetId();
    CNode* node = this->GenerateNode(id);
    node->SetRule(rule);

    // insert
    InsertNode(node);
  }
}

void CGraphPref::HandlePreferences(TRuleSet *rules,TPrefList *prefs,TAtomSet *atoms) {
	TPrefList::iterator ite1;
	TAtomSet::iterator ite2;
	TRuleSet::iterator ite3;
	TId idpref1,idpref2,ruleid1,ruleid2;
  for (ite1=prefs->begin();ite1!=prefs->end();ite1++) {
		ruleid1=ruleid2=0;
    idpref1=idpref2=0;
    string pref1 = "name("+ite1->first+")";
    string pref2 = "name("+ite1->second+")";    
		for (ite2=atoms->begin();ite2!=atoms->end();ite2++) {
			if (ite2->second->GetName()==pref1)
				idpref1 = ite2->second->GetId();
			else if (ite2->second->GetName()==pref2)
				idpref2 = ite2->second->GetId();
		}
		for (ite3=rules->begin();ite3!=rules->end();ite3++) {
			TAtomSet *posBody = ite3->second->GetpBody();
			if ((posBody->find(idpref1))!=posBody->end()) {
				ruleid1 = ite3->second->GetId();
			}
			else if ((posBody->find(idpref2))!=posBody->end()) {
				ruleid2 = ite3->second->GetId();
			}
		}
		CNodePref* node1 = (_pnodes->find(ruleid1) != _pnodes->end()) ? (CNodePref*)(*_pnodes)[ruleid1] : NULL;
		CNodePref* node2 = (_pnodes->find(ruleid2) != _pnodes->end()) ? (CNodePref*)(*_pnodes)[ruleid2] : NULL;
    if ((node1 != NULL) && (node2 != NULL)) {
      node1->InsertTwoPredecessor(node2);
  		node2->InsertTwoSuccessor(node1);
    }
	}
}

bool CGraphPref::RemoveMustBeMinus(CNodePref *node) {
	return _pmust_be_minus->erase(node->GetId());
}



} // end of namespace NS_NOMORE

