/***************************************************************************
                          cgraphpref.h  -  description
                             -------------------
    begin                : Wed Sep 1 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file cgraphpref.h
		Contains Definitions of CGraphPref */

#ifndef CGRAPHPREF_H
#define CGRAPHPREF_H

#include <iostream>
#include "misc.h"
#include "cgraph.h"
#include "cnodepref.h"

namespace NS_NOMORE {

class CGraphPref : public CGraph {
	//! Output operator
	friend std::ostream& operator<<(std::ostream& os, CGraph& graph);

protected:
  TNodeSet *_pmust_be_minus; //!< list of nodes which must be colored minus in the AS


  //! moves a node from one list to another
//  void MoveNode(CNode *node, TColor from, TColor to);

protected:
	//! Creates Nodes from a rule set
	void CreateNodes(TRuleSet*);

	//! Insert predecessor information
  void HandlePreferences(TRuleSet *rules,TPrefList *prefs,TAtomSet *atoms);

public:
	//! Constructor
//	CGraphPref();

  //! Constructor initializes the graph by a program
	CGraphPref(CProgram* prg);

	//! Destructor
	virtual ~CGraphPref();

  //! Returns the type of the graph
  virtual TType GetType() const {
    return type_cgraphpref;
  }

  //! Equality Operator
	bool operator==(const CGraphPref& graph);

	//! Inequality Operator
	bool operator!=(const CGraphPref& graph);

	virtual inline CNode* GenerateNode(const TId id) const {
    return (CNode*)new CNodePref(id);
  }

  //! Returns true if all nodes are not colored with color_none
//  virtual bool TotalColoring();

	//! returns uncolored nodes
  inline TNodeSet *GetMustBeMinusColored(){
  	return _pmust_be_minus;
  }

	bool RemoveMustBeMinus(CNodePref *node);
};

} // end of namespace NS_NOMORE


#endif
