/***************************************************************************
                          cnodepref.cpp  -  description
                             -------------------
    begin                : Wed Aug 25 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <cstdio>
#include "crule.h"
#include "misc.h"
#include "print.h"
#include "cnodepref.h"

using namespace std;

namespace NS_NOMORE {

/*****************************************************************************
 class CNodePref
*****************************************************************************/

CNodePref::CNodePref(CIdGenerator *ig) : CNode(ig) {
//	CHECK_POINTER("CNodePref::CNodePref(CIdGenerator*, CRule*) ig", ig);

  _ptwo_predecessors = new TNodeSet;
  _ptwo_successors = new TNodeSet;

//	_applied = 0;

  CREATEOBJECT("CNodePref")
}

CNodePref::CNodePref(CIdGenerator *ig, CRule *rule) : CNode(ig,rule) {
//	CHECK_POINTER("CNodePref::CNodePref(CIdGenerator*, CRule*) rule", rule);
//	CHECK_POINTER("CNodePref::CNodePref(CIdGenerator*, CRule*) ig", ig);

  _ptwo_predecessors = new TNodeSet;
  _ptwo_successors = new TNodeSet;

//	_applied = 0;

  CREATEOBJECT("CNodePref")
}

CNodePref::CNodePref(TId sid) : CNode(sid) {

  _ptwo_predecessors = new TNodeSet;
  _ptwo_successors = new TNodeSet;

//	_applied = 0;

  CREATEOBJECT("CNodePref")
}

CNodePref::CNodePref(TId sid, CRule *rule) : CNode(sid,rule) {
//	CHECK_POINTER("CNodePref::CNodePref(TId, CRule*)", rule);

  _ptwo_predecessors = new TNodeSet;
  _ptwo_successors = new TNodeSet;

//	_applied = 0;

  CREATEOBJECT("CNodePref")
}

CNodePref::~CNodePref() {
	delete _ptwo_successors;
	delete _ptwo_predecessors;

  DELETEOBJECT("CNodePref")
}

bool CNodePref::operator==(const CNode &rhs){
  if(GetType() != rhs.GetType())
    return false;

  CNodePref *node = (CNodePref*)&rhs;

	return (
		CNode::operator==(rhs) &&
		(*_ptwo_predecessors) == (*(node->_ptwo_predecessors))
	);

}

bool CNodePref::operator!=(const CNode &rhs){
	return !(operator==(rhs));
}

bool CNodePref::InsertTwoPredecessor(CNode* node) {
	CHECK_POINTER("CNodePref::InsertTwoPredecessor()", node);

//	TPrefList* preflist =

	pair<TNodeSet::iterator,bool> p = _ptwo_predecessors->insert(valType(node->GetId(),node));
	return p.second;
}

bool CNodePref::InsertTwoSuccessor(CNode* node){
	CHECK_POINTER("CNode::InsertTwoSuccessor()", node);

	pair<TNodeSet::iterator,bool> p = _ptwo_successors->insert(valType(node->GetId(),node));
	return p.second;
}

bool CNodePref::ColorNode(TColor color, TStack *stack, bool choice_point, TColor choice_color){
  INC_COUNT(methode_colornode);

  CHECK_POINTER("CNodePref::ColorNode()", stack);

  if ((color == color_plus) && (GetColor() == color_must_be_minus)) {
	  PRINT_DEBUG(cout << "color error" << endl);
		return false;
	}

  if ((color == color_minus) && (GetColor() == color_must_be_minus) && !Unsupported()) {
	  PRINT_DEBUG(cout << "color error" << endl);
		return false;
	}
 //new 
  if ((color == color_plus) && (GetColor() == color_was_plus)) {
	  PRINT_DEBUG(cout << "color error" << endl);
		return false;
	}
//new
 if ((color == color_minus) && (GetColor() == color_was_minus)) {
	  PRINT_DEBUG(cout << "color error" << endl);
		return false;
	}	
  if ((GetColor() == color_none) || (GetColor() == color_must_be_minus) || (GetColor() == color_was_plus)) {
    TStackElement elem;

    elem._Node = this;
    elem._ChoicePoint = choice_point;
    elem._ChoicePointColor = choice_color;

    PRINT_DEBUG_MORE(cout << "saving node: ");

    elem._Data = SaveState(elem._Size);
    stack->push(elem);

	  SetColor(color);

    PRINT_DEBUG(cout << "  Coloring " << GetId() << " with " << color << endl);

		TNodeSet::iterator ite;
		if (color == color_plus) {
			TNodeSet *zero_succs = GetZeroSuccessors();
			for (ite=zero_succs->begin();ite!=zero_succs->end();ite++) {
				TId id = GetRule()==NULL?0:
							(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
//				int i=ite->second->GetSupported()[id];
				ite->second->DecSupported(id);
//				i=ite->second->GetSupported()[id];
			}
			TNodeSet *one_succs = GetOneSuccessors();
			for (ite=one_succs->begin();ite!=one_succs->end();ite++) {
//				int i=ite->second->GetBlocked();
				ite->second->DecBlocked();
//				i=ite->second->GetBlocked();
			}
		}

		if (color == color_minus || color == color_must_be_minus) {
			TNodeSet *zero_succs = GetZeroSuccessors();
			for (ite=zero_succs->begin();ite!=zero_succs->end();ite++) {
				TId id = GetRule()==NULL?0:
							(GetRule()->GetHeads()==NULL?0:GetRule()->GetHeads()->begin()->first);
//				int i=ite->second->GetUnsupported()[id];
				ite->second->DecUnsupported(id);
//				i=ite->second->GetSupported()[id];
			}
			TNodeSet *one_succs = GetOneSuccessors();
			for (ite=one_succs->begin();ite!=one_succs->end();ite++) {
//				int i=ite->second->GetUnblocked();
				ite->second->DecUnblocked();
//				i=ite->second->GetBlocked();
			}
		}

    return true;
  }	else
  if (GetColor() == color)
		return true;

  PRINT_DEBUG(cout << "color error" << endl);

  return false;
}


//!!!! bei maximal auch schwach minus beachten

bool CNodePref::Maximal(){
	INC_COUNT(methode_maximal);

  TNodeSet::iterator ite;

  for(ite=_ptwo_predecessors->begin();ite!=_ptwo_predecessors->end();ite++) {
  	CNode *node = ite->second;
		TColor color=node->GetColor();
    if((color != color_plus) && (color != color_minus) && (color != color_must_be_minus))
      return false;
	}

  return true;
}


//!!!! bei maximal auch schwach minus beachten
bool CNodePref::Maximal(TNodeSet* set) {
	STARTTIMER;
  INC_COUNT(methode_maximal_by_set);

	TNodeSet::iterator ite;

  if(_ptwo_predecessors->empty()) {
  	STOPTIMER;
  	return true;
  }

  for(ite=_ptwo_predecessors->begin();ite!=_ptwo_predecessors->end();ite++) {
		CNode* node = ite->second;
		TColor color = node->GetColor();
		if ((color != color_plus) && (color != color_minus) || (set->find(node->GetId()) == set->end())) {
			STOPTIMER;
			return false;
		}
	}

	STOPTIMER;
	return true;


}

} // end of namespace NS_NOMORE

