/***************************************************************************
                          coperator.h  -  description
                             -------------------
    begin                : Mon Aug 23 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*! \file coperator.h
		Declaration of class COperator, CDetOperator, COperatorP, CDetOperatortodo,
    COperatorPtodo, COperatorU, COperatorUtodo, COperatorV, COperatorN, COperatorNtodo,
    COperatorPre, COperatorPretodo und CDetOperatorNone
*/

#ifndef COPERATOR_H
#define COPERATOR_H

#include "cgraph.h"

namespace NS_NOMORE {

/*! \class COperator coperator.h
		\brief Interface for defining operators.

		COperator is the base class for all operators and handles a TODO list for different operators.
*/
class COperator {
private:
	static TQueue _todo;//!< todo list
  static TChoices _choices;//!< list of choice points
//  static long _reference_counter;//!< counter for references to any operator
	static bool _istodo;

public:
  //! constructor
	COperator();

	COperator(bool todo);

  //! destructor
	virtual ~COperator();

  //! returns an operator specific id which is used for testing of equality
  virtual TType GetType() = 0;

  //! Equality operator work on operator ids
  virtual bool operator==(COperator& op);

  //! Inequality operator work on operator ids
  virtual bool operator!=(COperator& op);

  //! Returns true if TODO is empty.
  bool EmptyTodo();

  //! Returns on element of TODO.
  CNode* GetTodoHead();

  //! Inserts node into TODO.
  void InsertTodo(CNode*);

  //! Inserts node set into TODO.
  void InsertTodo(TNodeSet*);

  //! Returs TODO
  static inline TQueue *GetTodo() {
		return &_todo;
  }

  //! Clears the TODO list
  inline void ClearTodo() {
    while(!_todo.empty())
      _todo.pop();
  }

  //! Returns true if the choice list is empty.
  bool EmptyChoicePoints();

  //! Returns on element of choice list.
  CNode* GetChoicePoint();

  //! Inserts node into choice list.
  void InsertChoicePoint(CNode*);

  //! Inserts node set into choice list.
  void InsertChoicePoints(TNodeSet*);

  //! Returs choice list
  inline TChoices *GetChoicePoints() {
		return &_choices;
  }

  //! Clears the choice list
  inline void ClearChoicePoints() {
    while(!_choices.empty())
      _choices.pop();
  }

  //! Colors a node.
  virtual bool ColorNode(CGraph* graph, CNode *node, TColor color, TStack *stack,
                         bool choice_point, TColor choice_color);

  //! Returns true if the input operator id is in conflict with actual operator
  virtual bool Conflict(TType op);

	inline bool IsTodo() {
		return _istodo;
	}

	static inline void SetIsTodo(bool istodo) {
		_istodo = istodo;
	}

//! Generates the aggregation tree out of the input string
/*! \param op Input string which specifies the operators ("Pre:Choice:Det:Closure")
    \param det_out Deterministic output operator
    \param pre_out Deterministic output operator
    \param ndet_out Non-deterministic output operator
    \return if the input string syntax is ok and the operators are created the methode return true else false*/
	bool GenerateOperator(string op, COperator*& det_out,
																	 COperator*& pre_out,
																	 COperator*& ndet_out,
																	 COperator*& end_out);

};


} // end of namespace NS_NOMORE

#endif
