/***************************************************************************
                          cprogram.cpp  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <algorithm>
#include <iostream>
#include "cprogram.h"
#include "misc.h"
#include "print.h"

using namespace std;

namespace NS_NOMORE {

/**********************************************************************************************************
  class CProgram
**********************************************************************************************************/
CProgram::CProgram(){
	_patoms = new TAtomSet;
	_prules = new TRuleSet;
	_ppreflist = new TPrefList;
	_patomsandrules = new TSetOfRuleSet;
  _pbminus = new TAtomSet;

  CREATEOBJECT("CProgram")
}

CProgram::~CProgram(){
  TAtomSet::iterator ite;
  for(ite=_patoms->begin();ite!=_patoms->end();ite++)
  	delete (*ite).second;


  TRuleSet::iterator ite2;
  for(ite2=_prules->begin();ite2!=_prules->end();ite2++)
   	delete (*ite2).second;


  delete _patoms;
	delete _prules;
	delete _ppreflist;
	delete _patomsandrules;
  delete _pbminus;

  DELETEOBJECT("CProgram")
}

void CProgram::AddAtoms(TAtomSet *atoms) {
  TAtomSet::iterator ite;
  CAtom *atom;
  TId id;

  for (ite = atoms->begin(); ite != atoms->end(); ite++) {
   	id = ite->first;
		if ((*_patoms)[id] == NULL) {
			atom = ite->second;
			(*_patoms)[id] = atom;
		}
  }
}


bool CProgram::AddRuleForAtom(CAtom *a, CRule *r) {
	TRuleSet *rules = (*_patomsandrules)[a->GetId()];
	if (rules == NULL) {
		rules = new TRuleSet();
		(*rules)[r->GetId()] = r;
		(*_patomsandrules)[a->GetId()] = rules;
	}
	else {
		(*rules)[r->GetId()] = r;
	}
	return true;
}


bool CProgram::ReadBody(std::istream &f, long size, long size_neg, CRule* rule) {
	TId id;
	CAtom *atom;
	long i;

	for (i = 0; i < size_neg; i++) {
		f >> id;
		if (!f.good() || id < 1) {
			PRINT_ERROR(cerr << "atom out of bounds" << endl);
			return false;
		}

		atom = (*_patoms)[id];
		if (atom == NULL)
			atom = new CAtom(id);

		rule->InsertNegAtom(atom);
		InsertAtom(atom);
	}

	long size_pos = size - size_neg;
/*	if (size_pos > 1) {
		PRINT_ERROR(cerr << "More than one positive body literal" << endl);
		exit(1);
	}
*/
	for (i = 0; i < size_pos; i++) {
		f >> id;
		if (!f.good() || id < 1) {
			PRINT_ERROR(cerr << "atom out of bounds" << endl);
			return false;
		}

		atom = (*_patoms)[id];
		if (atom == NULL)
				atom = new CAtom(id);
		rule->InsertPosAtom(atom);
	}

	return true;
}

bool CProgram::AddBasicRule(std::istream &f) {
	TId head_id;
	f >> head_id;
	if (!f.good() || head_id < 1) {
		PRINT_ERROR(cerr << "head atom out of bounds" << endl);
		return false;
	}

	CAtom *head = (*_patoms)[head_id];
	if (head == NULL) {
		head = new CAtom(head_id);
		InsertAtom(head);
	}
	CIdGenerator *id = new CIdGenerator;
	CRule *rule = new CRule(id);
	delete id;
	rule->InsertHead(head);

	long body_size;
	f >> body_size;
	if (!f.good() || body_size < 0) {
		PRINT_ERROR(cerr << "body_size out of bounds" << endl);
		return false;
	}

	long neg_body_size;
	f >> neg_body_size;
	if (!f.good() || neg_body_size < 0 || neg_body_size > body_size) {
		PRINT_ERROR(cerr << "neg_body_size out of bounds" << endl);
		return false;
	}

	if (!ReadBody(f,body_size,neg_body_size,rule))
		return false;
	else {
		InsertRule(rule);
		AddRuleForAtom(head,rule);
		return true;
	}
}


bool CProgram::Read(std::istream &f){
	// read rules
	int type;
	bool stop = false;
	while (!stop) {
		f >> type;
		switch (type) {
			case ENDRULE :
				stop = true;
				break;
			case BASICRULE:
				if (!AddBasicRule(f))
					return false;
				break;
			default:
				return false;
		}
	}

	// read atom names
	const int len = 1024;
	char name[len], space;
	TId id;
  memset(name,0,len);
	f.getline(name, len);  // Get newline
	if (!f.good()) {
		PRINT_ERROR(cerr << "expected atom names to begin on new line" << endl);
		return false;
	}
	f >> id;
	f.get(space); // get rid of useless " "
	f.getline(name, len);
	CAtom *atom;
	while (id) {
		if (!f.good()) {
			PRINT_ERROR(cerr << "atom name too long or end of file" << endl);
			return false;
		}

		atom = (*_patoms)[id];
		if ( atom == NULL ) {
			PRINT_ERROR(cerr << "found unused atom" << id << endl);
			return false;
		}
		else {
			atom->SetName(name);
		}
		f >> id;
		f.get(space); // get rid of useless " "
    memset(name,0,len);
    f.getline (name, len);
	}

	char s[len];
	// read B+
  if (!f.good () || strcmp (name, "B+"))
    {
      cerr << "B+ expected" << endl;
      return false;
    }
  f >> id;
	if (id != 0) {
		cerr << "cannot handle pos compute statements" << endl;
		return false;
	}
/*  while (i)
    {
      if (!f.good () || i < 1)
	{
	  cerr << "B+ atom out of bounds, line " << linenumber << endl;
	  return 1;
	}
      Atom *a = getAtom (i);
      api->set_compute (a, true);
      f >> i;
      linenumber++;
    }*/
  f.getline (s, len);  // Get newline.
	// read B-
  f.getline (s, len);
  if (!f.good () || strcmp (s, "B-"))
    {
      cerr << "B- expected, line " << endl;
      return 1;
    }
  f >> id;
/*	if (id != 0) {
		cerr << "cannot handle neg compute statements" << endl;
		return false;
	}*/
  while (id) {
    if (!f.good() || id <1) {
      cerr<< "B- atom out of bounds" << endl;
      return 1;
    }
//    CAtom *a = _patoms->find(id)->second;
      (*_pbminus)[id] = _patoms->find(id)->second;
//      (*_pbminus)[id] = _patoms[id];
//    cout<<_pbminus[id];
    f >> id;
  }  
/*  while (i)
    {
      if (!f.good () || i < 1)
	{
	  cerr << "B- atom out of bounds, line " << linenumber << endl;
	  return 1;
	}
      Atom *a = getAtom (i);
      api->set_compute (a, false);
      f >> i;
      linenumber++;
    }
  f >> models;  // zero means all
  if (f.fail ())
    {
      cerr << "number of models expected, line " << linenumber << endl;
      return 1;
    }
  return 0;*/
  
  RemoveUnsupportedRules();
	return true;
}

bool CProgram::ReadWithPrefs(std::istream &f){
	// read rules
	int type;
	bool stop = false;
	while (!stop) {
		f >> type;
		switch (type) {
			case ENDRULE :
				stop = true;
				break;
			case BASICRULE:
				if (!AddBasicRule(f))
					return false;
				break;
			default:
				return false;
		}
	}

	// read atom names
	const int len = 1024;
	char name[len], space;
	TId id;
  memset(name,0,len);
	f.getline(name, len);  // Get newline
	if (!f.good()) {
		PRINT_ERROR(cerr << "expected atom names to begin on new line" << endl);
		return false;
	}
	f >> id;
	f.get(space); // get rid of useless " "
	f.getline(name, len);
	CAtom *atom;
	while (id) {
		if (!f.good()) {
			PRINT_ERROR(cerr << "atom name too long or end of file" << endl);
			return false;
		}

		atom = (*_patoms)[id];
		if ( atom == NULL ) {
			PRINT_ERROR(cerr << "found unused atom" << id << endl);
			return false;
		}
		else {
			atom->SetName(name);

    	string line(name);
  		int exists = line.find("preferred(");
      if (exists >= 0) {
		    string rule1,rule2;

        int i = line.find("(");
        int j = line.rfind(")");
        string str = line.substr(i+1,j-i-1);
        int count = 0;
        for (int k = 0; k < str.length(); k++) {
          if (str[k] == '(' ) count++;
          else if (str[k] == ')') count--;
          else if ((str[k] == ',') && (count == 0)) {
            rule1 = str.substr(0,k);
            rule2 = str.substr(k+1,str.length());
            AddPref(rule2,rule1);
            break;
          }
        }
        
/*        int i = line.find("(");
        int j = line.find(",");
        int k = line.find(",");
        int l = line.rfind(",");
        string str = line;
        if (k != l) {
          while (k != l) {
            str = str.substr(k+1,str.length());
            k = str.find(",");
            l = str.rfind(",");
            j += k-1;
          }
     		  rule2 = line.substr(i+1,j-i-2);
   	  	  rule1 = line.substr(j,line.length()-j-1);
    		  AddPref(rule1,rule2);
        } else {
  		  rule2 = line.substr(i+1,j-i-1);
	  	  rule1 = line.substr(j+1,line.length()-j-2);
//	  	  rule1 = line.substr(j,line.length()-j-1);
  		  AddPref(rule1,rule2)
        }*/
/*        TRuleSet::iterator ite;
        for (ite=_prules->begin();ite!=_prules->end();ite++) {
          string name = ite->second->GetHeads()->begin()->second->GetName();
          if (line.find(name) >= 0) {
            _prules->erase(ite->first);
            break;
          }
        }*/
      }
      
		}
		f >> id;
		f.get(space); // get rid of useless " "
    memset(name,0,len);
    f.getline (name, len);
	}

	char s[len];
	// read B+
  if (!f.good () || strcmp (name, "B+"))
    {
      cerr << "B+ expected" << endl;
      return false;
    }
  f >> id;
	if (id != 0) {
		cerr << "cannot handle pos compute statements" << endl;
		return false;
	}
  f.getline (s, len);  // Get newline.
	// read B-
  f.getline (s, len);
  if (!f.good () || strcmp (s, "B-"))
    {
      cerr << "B- expected, line " << endl;
      return 1;
    }
  f >> id;
/*	if (id != 0) {
		cerr << "cannot handle neg compute statements" << endl;
		return false;
	}*/
  while (id) {
    if (!f.good() || id <1) {
      cerr<< "B- atom out of bounds" << endl;
      return 1;
    }
//    CAtom *a = _patoms->find(id)->second;
      (*_pbminus)[id] = _patoms->find(id)->second;
//      (*_pbminus)[id] = _patoms[id];
//    cout<<_pbminus[id];      
    f >> id;
  }
	CreateTransitivePrefs();
  RemoveUnsupportedRules();
	return true;
}


bool CProgram::RemoveUnsupportedRules() {
  TRuleSet::iterator ite1;
  TAtomSet::iterator ite2;
  bool changed = true;
  while (changed) {
    changed = false;
    TAtomSet* heads = new TAtomSet();
    for (ite1=_prules->begin();ite1!=_prules->end();ite1++) {
      CAtom* a=ite1->second->GetHeads()->begin()->second;
      TId id=a->GetId();
      (*heads)[a->GetId()] = a;
    }
    for (ite1=_prules->begin();ite1!=_prules->end();ite1++) {
      TAtomSet* pbody=ite1->second->GetpBody();
      for (ite2=pbody->begin();ite2!=pbody->end();ite2++) {
        if (heads->find(ite2->first) == heads->end()) {
            int atomid = ite1->second->GetHeads()->begin()->first;
            TRuleSet *r = (_patomsandrules->find(atomid) != _patomsandrules->end()) ?
                          (*_patomsandrules)[atomid] : NULL;
            if (r != NULL) {
                r->erase(ite1->first);
            }
            _prules->erase(ite1->first);
            changed = true;
            break;
        }
      }
    }
  }
}

bool CProgram::operator!=(const CProgram& prg) const{
  return !((*this) == prg);
}

bool CProgram::operator==(const CProgram& prg) const{
  return (*_prules == *prg._prules);
}

//inserts rule into _prules if id doesn't exist yet, adds all new atoms occuring in this
//rule to _patoms
void CProgram::InsertRule(CRule* rule){
	CHECK_POINTER("CProgram::InsertRule()", rule);

	if ((*_prules)[rule->GetId()] == NULL)
	  (*_prules)[rule->GetId()] = rule;
	else
		if ((*_prules)[rule->GetId()] != rule) {
			PRINT_ERROR(cerr << "trying to overwrite rule in a program" << endl);
			exit(1);
		}

  TAtomSet *atoms;
  // handle head atoms
  atoms = rule->GetHeads();
  AddAtoms(atoms);

  // handle pbody atoms
  atoms = rule->GetpBody();
  AddAtoms(atoms);

  // handle nbody atoms
  atoms = rule->GetnBody();
  AddAtoms(atoms);
}

void CProgram::InsertAtom(CAtom* atom){
	CHECK_POINTER("CProgram::InsertAtom()", atom);

  if ((*_patoms)[atom->GetId()] == NULL)
  	(*_patoms)[atom->GetId()] = atom;
	else
		if ((*_patoms)[atom->GetId()] != atom) {
			PRINT_ERROR(cerr << "trying to overwrite atom in a program" << endl);
			exit(1);
		}

}

CRule* CProgram::GetRule(TId id){
  TRuleSet::iterator ite = _prules->find(id);

  if(ite != _prules->end())
    return (*ite).second;
  else
    return NULL;
}

CAtom* CProgram::GetAtom(TId id){
  TAtomSet::iterator ite = _patoms->find(id);

  if(ite != _patoms->end())
    return (*ite).second;
  else
    return NULL;
}

bool CProgram::ReadPref(std::istream &f){
/*	const int len = 1024;
	char input[len];
	while (f.getline(input, len)) {
		if (!f.good()) {
			PRINT_ERROR(cerr << "expected atom names to begin on new line" << endl);
			return false;
		}
  	string line(input);
		int position = line.find("<");
		string rule1,rule2;
		rule1 = line.substr(0,position);
		rule2 = line.substr(position+1,line.length());
//		_ppreflist->push_back(pair<string,string>(rule1,rule2));
		AddPref(rule1,rule2);
	}
	CreateTransitivePrefs();
	return true; */

 	const int len = 1024;
	char input[len], space;
  f.get(space);
	while (f.getline(input, len)) {
		if (!f.good()) {
			PRINT_ERROR(cerr << "expected atom names to begin on new line" << endl);
			return false;
		}
  	string line(input);
		int exists = line.find("preferred");
    if (exists >= 0) {
		  string rule1,rule2;
      int i = line.find("(");
      int j = line.find(",");
//      int k = line.find(")");
//      cout<<line.length()<<endl<<line<<"!"<<endl;
//		  rule1 = line.substr(i+1,j-i-1);
//		  rule2 = line.substr(j+1,line.length()-j-2);
		  rule2 = line.substr(i+1,j-i-1);
		  rule1 = line.substr(j+1,line.length()-j-2);
//		_ppreflist->push_back(pair<string,string>(rule1,rule2));
		  AddPref(rule1,rule2);
      TRuleSet::iterator ite;
      for (ite=_prules->begin();ite!=_prules->end();ite++) {
        string name = ite->second->GetHeads()->begin()->second->GetName();
        if (line.find(name) >= 0) {
          _prules->erase(ite->first);
          break;
        }
      }
	  }
    f.get(space);
  }
	CreateTransitivePrefs();
	return true;
}


void CProgram::CreateTransitivePrefs() {
	TPrefList::iterator ite1,ite2;
	TPrefList newprefs;
	bool changed=true;
	bool exists=false;
	while(changed) {
		changed=false;
	 	for (ite1=_ppreflist->begin();ite1!=_ppreflist->end();ite1++) {
			for (ite2=_ppreflist->begin();ite2!=_ppreflist->end();ite2++) {
				if (ite1->first==ite2->second) {
					TPrefList::iterator ite3;
					exists=false;
					for (ite3=_ppreflist->begin();ite3!=_ppreflist->end();ite3++) {
						if ((ite3->first == ite2->first) && (ite3->second == ite1->second))
            	exists=true;
					}
					if (!exists) {
						AddPref(ite2->first,ite1->second);
//						cout<<"added: "<<ite2->first<<" < "<<ite1->second<<endl;
						changed=true;
					}
				}
			}
		}
	}
}

/*void CProgram::DeletePreferredRules(){
  TPrefList::iterator ite1;
  TAtomSet::iterator ite2;
  TRuleSet::iterator ite3;
  for (ite1=_preflist->begin();ite1!=_preflist->end();ite1++) {
    string name = ite1->second;
    Id id = -1;
    for (ite2=_patoms->begin();ite2!=_patoms->end();ite2++) {
      if (ite2->second->GetName() == name) {
        id=ite2->first;
        break;
      }
    }
    if (id >= 0) {
      for (ite3=_prules->begin();ite3!=_prules->end();ite3++) {
        if (ite3->second->GetHeads()->begin()->first == id) {
          _prules->erase(ite3->first);
          break;
        }    
      }
    }
} */

} //end of NS_NOMORE
