/***************************************************************************
                          crule.cpp  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <algorithm>
#include "crule.h"
#include "print.h"

using namespace std;

namespace NS_NOMORE {

/**********************************************************************************************************
  class CAtom
**********************************************************************************************************/
CAtom::CAtom(const TId id) : _name("") {
  _id = id;

  CREATEOBJECT("CAtom")
}

CAtom::CAtom(const TId id, const string name){
  _name = name;
  _id = id;

  CREATEOBJECT("CAtom")
}

CAtom::CAtom(CIdGenerator *ig){
	CHECK_POINTER("CAtom::CAtom(CIdGenerate*)", ig);

  _name = "";
  _id = ig->GetId();

  CREATEOBJECT("CAtom")
}

CAtom::CAtom(CIdGenerator *ig, const string name){
	CHECK_POINTER("CAtom::CAtom(CIdGenerate*, const string)", ig);

  _name = name;
  _id = ig->GetId();

  CREATEOBJECT("CAtom")
}

CAtom::~CAtom(){
  DELETEOBJECT("CAtom")
}

bool CAtom::operator!=(const CAtom& atom){
  return !((*this) == atom);
}

bool CAtom::operator==(const CAtom& atom){
  return _name == atom._name;
}

void CAtom::SetName(const string& name){
  _name = name;
}

void CAtom::SetId(const TId id){
  _id = id;
}

/*******************************************************************
  classCRule
*******************************************************************/
CRule::CRule(const TId id){
  _id = id;

  _pheads = new TAtomSet;
  _pnbody = new TAtomSet;
  _ppbody = new TAtomSet;

  CREATEOBJECT("CRule")
}

CRule::CRule(CIdGenerator *ig){
	CHECK_POINTER("CRule::CRule(CIdGenerate*)", ig);

  _id = ig->GetId();

  _pheads = new TAtomSet();
  _pnbody = new TAtomSet();
  _ppbody = new TAtomSet();

  CREATEOBJECT("CRule")
}

CRule::~CRule(){
  _pheads->clear();
  _pnbody->clear();
  _ppbody->clear();

  delete _pheads;
  delete _pnbody;
  delete _ppbody;

  DELETEOBJECT("CRule")
}

bool CRule::operator==(CRule& rule) {
  return ((*rule._pheads) == (*_pheads) &&
          (*rule._pnbody) == (*_pnbody) &&
          (*rule._ppbody) == (*_ppbody));
}

bool CRule::operator!=(CRule &rule) {
	return !(operator==(rule));
}

void CRule::InsertHead(CAtom* atom){
	CHECK_POINTER("CRule::InsertHead()", atom);

  (*_pheads)[atom->GetId()] = atom;
}

void CRule::InsertPosAtom(CAtom* atom){
	CHECK_POINTER("CRule::InsertPosAtom()", atom);
  if(atom == NULL)
    return;
  (*_ppbody)[atom->GetId()] = atom;
}

void CRule::InsertNegAtom(CAtom* atom){
	CHECK_POINTER("CRule::InsertNegAtom()", atom);
  if(atom == NULL)
    return;
  (*_pnbody)[atom->GetId()] = atom;
}

} // end of namespace NS_NOMORE
