/***************************************************************************
                          cset.h  -  description
                             -------------------
    begin                : Mon Jul 28 2003
    copyright            : (C) 2003 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef CSET_H
#define CSET_H

/*! \file cset.h
		Contains Definitions of CSet */

#include <map>
#include "print.h"

namespace NS_NOMORE {

/*! \class CSet
		\brief Defines a map with equality- and inequaltity-operator.

    \note Important is that the data-class is a pointer, else the equality-operator doesn't work */
template<class Key, class Data>
class CSet : public std::map<Key, Data>{
public:
	typedef typename map<Key,Data>::iterator iterator;
  //! constructor
  CSet();

  //! copy constructor
  CSet(const CSet& set);

  //! destructor
  virtual ~CSet();

  //! equality operator working on pointers
  bool operator==(CSet<Key, Data>& set);

  //! inequality operator working on pointers
  bool operator!=(CSet<Key, Data>& set);
};


template <class Key, class Data>
CSet<Key,Data>::CSet() : std::map<Key, Data>() {
  CREATEOBJECT("CSet");
}

template <class Key, class Data>
CSet<Key,Data>::CSet(const CSet& set) : std::map<Key, Data>(set){
//  *this = set;
  CREATEOBJECT("CSet");
}

template <class Key, class Data>
CSet<Key,Data>::~CSet(){
  DELETEOBJECT("CSet");
}

template <class Key, class Data>
bool CSet<Key,Data>::operator==(CSet<Key, Data>& set){
  if(set.size() != this->size())
    return false;

  iterator ite;
  iterator ite2;

  if(!this->empty())
    for(ite = this->begin();ite != this->end();ite++) {
      for(ite2 = set.begin();ite2 != set.end();ite2++) {
        if(*(ite->second) == *(ite2->second))
          break;
      }
      if(ite2 == set.end())
        return false;
    }

  return true;
}

template <class Key, class Data>
bool CSet<Key,Data>::operator!=(CSet<Key, Data>& set){
  return !(operator==(set));
}

}

#endif
