/***************************************************************************
                          io.cpp  -  description
                             -------------------
    begin                : Mon Aug 23 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

//#include "algorithm.h"
//#include "caggregation.h"
#include "cgraph.h"
#include "cnode.h"
#include "cnodepref.h"
#include "cdetoperator.h"
#include "cprogram.h"

#include "crule.h"

namespace NS_NOMORE{

/**********************************************************************************************************
  algorithm.h
**********************************************************************************************************/
// class CNdOperator
/*std::ostream& operator<<(std::ostream& os, CNdOperator& op){
  if(op.GetType() == type_coperator_c)
    os << "choice operator chooses any uncolored node";
  return os;
}

*/

/**********************************************************************************************************
  cgraph.h
**********************************************************************************************************/
// class CGraph
ostream& operator<<(ostream& os, CGraph& graph){
	os << "Graph contains the following nodes:" << endl;
	TNodeSet::iterator ite;
	for (ite=graph._pnodes->begin();ite!=graph._pnodes->end();ite++)  {
		os << *(CNode*)ite->second << endl;
		if (ite->second->GetType() == type_cnodepref)
			os << *(CNodePref*)ite->second << endl;
	}
	os << "End of Graph";
	return os;
} 

/**********************************************************************************************************
  cnode.h
**********************************************************************************************************/
// class CNode
ostream& operator<<(ostream& os, CNode& node) {
	os << "Node:" << endl
		 << "Id:           " << node._id << endl
	   << "Color:        " << node._color << endl
		 << "Type:         " << node.GetType() << endl
		 << "Rule:         " << *(node._prule) << endl
	   << "0-Preds:      ";

	TSetOfNodeSets::iterator iter = node._pzero_predecessors->begin(),
										 iter_end = node._pzero_predecessors->end();
	while (iter != iter_end) {
		TNodeSet::iterator iter1 = iter->second->begin(),
										 iter1_end = iter->second->end();
		while (iter1 != iter1_end) {
			os <<	(*iter1).second->GetId() << " ";
			iter1++;
		}
		iter++;
	}

	os << endl;

	os << "1-Preds:      ";
	TNodeSet::iterator iter2 = node._pone_predecessors->begin(),
										 iter2_end = node._pone_predecessors->end();
	while (iter2 != iter2_end) {
		os <<	(*iter2).second->GetId() << " ";
		iter2++;
	}

	os << endl;

	os << "0-Succs:      ";

	iter2 = node._pzero_successors->begin();
	iter2_end = node._pzero_successors->end();
	while (iter2 != iter2_end) {
		os <<	(*iter2).second->GetId() << " ";
		iter2++;
	}

	os << endl;

	os << "1-Succs:      ";
	iter2 = node._pone_successors->begin();
	iter2_end = node._pone_successors->end();
	while (iter2 != iter2_end) {
		os <<	(*iter2).second->GetId() << " ";
		iter2++;
	}

  os << endl;
  return os;
}


//class CNodePref
ostream& operator<<(ostream& os, CNodePref& node) {
//	os << *(CNodeFG*)node << endl;

	TNodeSet::iterator iter2 = node._ptwo_predecessors->begin(),
										 iter2_end = node._ptwo_predecessors->end();

	os << "2-Preds:      ";

	while (iter2 != iter2_end) {
		os <<	(*iter2).second->GetId() << " ";
		iter2++;
	}

	os << endl;

	os << "2-Succs:      ";
	iter2 = node._ptwo_successors->begin();
	iter2_end = node._ptwo_successors->end();
	while (iter2 != iter2_end) {
		os <<	(*iter2).second->GetId() << " ";
		iter2++;
	}

  os << endl;
  return os;
} 

/**********************************************************************************************************
  coperator.h
**********************************************************************************************************/
// class CDetOperator
std::ostream& operator<<(std::ostream& os, CDetOperator& op){
//  CAggregation* agg;
  if(op.GetType() == type_coperator_p)
    os << "P"; else
  if(op.GetType() == type_coperator_u)
    os << "U"; else
/*  if(op.GetType() == type_caggregation_star){
    agg = (CAggregation*)&op;;
    os << *agg->GetFirst() << "*";
  } else
  if(op.GetType() == type_caggregation_sequence){
    agg = (CAggregation*)&op;;
    os << "(" << *agg->GetFirst() << "," << *agg->GetSecond() << ")";
  }*/

  return os;
} 



/**********************************************************************************************************
  cprogram.h
**********************************************************************************************************/
// class CProgram
ostream& operator<<(ostream& os, CProgram& program) {
  os << " Atoms : ";

  TAtomSet::iterator ite;
  for(ite= (program.GetAtoms())->begin();ite!=(program.GetAtoms())->end();ite++)
    os << "  Atom(" << (*ite).first << "): " << (*ite).second->GetName() << " ";
  os << endl;

	TRuleSet::iterator ite2;
  os << " Rules: ";
  for(ite2=(program.GetRules())->begin();ite2!=(program.GetRules())->end();ite2++)
    os << *(*ite2).second << endl;
  os << endl;

	os << " Atoms and Rules: " << endl;
	TSetOfRuleSet::iterator ite3;
	for (ite3=(program.GetAtomsAndRules())->begin();ite3!=(program.GetAtomsAndRules())->end();ite3++) {
		os << (program.GetAtom(ite3->first))->GetName() << " : ";
		for (ite2=ite3->second->begin();ite2!=ite3->second->end();ite2++) 
			os << ite2->first << "  ";
		os << endl;
	}
	return os;
}



/**********************************************************************************************************
  crule.h
**********************************************************************************************************/
// class CAtom
ostream& operator<<(ostream& os, CAtom& atom) {
	os << "Id: " << atom._id << " Name: " << atom._name;
	return os;
}

// class CRule
ostream& operator<<(ostream& os, CRule& rule) {
  os << " Id : " << rule._id << endl;

  TAtomSet::iterator ite;
  TAtomSet *atoms = rule.GetHeads();
	if (!atoms->empty()) {
	  os << " Heads : ";

  	for(ite=atoms->begin();ite!=atoms->end();ite++) {
  		CAtom *atom = ite->second;
	    os << "  " << *atom << endl;
  	}
  }

  os << " PosBody : ";
  for(ite=rule.GetpBody()->begin();ite!=rule.GetpBody()->end();ite++)
    os << "  " << *(*ite).second << endl;

  os << " NegBody : ";
  for(ite=rule.GetnBody()->begin();ite!=rule.GetnBody()->end();ite++)
    os << "  " << *(*ite).second << endl;

	return os;
}


} //end of namespace
