/***************************************************************************
                          misc.h  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


/*! \file misc.h
		Declaration of different types and class CIdGenerator
*/

#ifndef __misc_h__
#define __misc_h__

#include <map>
#include <list>
#include <vector>
#include <queue>
#include <stack>
#include "print.h"
#include "cset.h"


namespace NS_NOMORE {

class CNode;
class CAtom;
class CRule;
class COperator;

// typedefs
/*! \enum TColor
		\brief Defines different possible colors.
*/
typedef enum {
	color_none = 0,
	color_minus,
	color_plus,
	color_weak_plus,
	color_must_be_minus,
	color_was_plus,
	color_was_minus,
	color_unknown
} TColor;

/*! \enum TRetOperator
		\brief Defines different possible errors returning an operator.
*/
typedef enum {
	return_unchanged = 0,
	return_changed,
	return_colorerror,
  return_inputerror,
  return_unknown
} TRetOperator;

/*! \enum TType
		\brief Defines different possible types. Used to determine the type of a particular instance.
*/
typedef enum {
	type_cnode = 0,
	type_cnodepref,
  type_cgraph,
	type_cgraphpref,
	type_coperator_p,
  type_coperator_ptodo,
	type_coperator_ps,
  type_coperator_pstodo,
	type_coperator_psl,
  type_coperator_psltodo,
  type_coperator_u,
  type_coperator_utodo,
  type_coperator_v,
  type_coperator_vtodo,
  type_coperator_n,
  type_coperator_ntodo,
  type_coperator_c,
  type_coperator_ctodo,
  type_coperator_c1,
  type_coperator_c1todo,
  type_coperator_d,
  type_coperator_dtodo,
  type_coperator_d2todo,
  type_coperator_pre,
  type_coperator_pretodo,
  type_cdetoperator_none,
  type_cdetoperator_nonetodo,
  type_caggregation_star,
  type_caggregation_sequence,
	type_coperator_ppref,
	type_coperator_ppreftodo,
	type_coperator_pspref,
	type_coperator_pspreftodo,
	type_coperator_pslpref,
  type_coperator_pslpreftodo,
	type_coperator_upref,
	type_coperator_upreftodo,
  type_coperator_dpref,
  type_coperator_dpreftodo,
  type_coperator_d2pref,
  type_coperator_d2preftodo,  
  type_coperator_prepref,
  type_coperator_prepreftodo,
  type_coperator_hpref,
  type_coperator_dprefh,
  type_coperator_dprefhtodo,
  type_coperator_hpreftodo,
	type_unknown
} TType;

/*! \enum TRuleType
		\brief From SModels! Defines different rule types.
*/
typedef enum {
  ENDRULE,
  BASICRULE,
  CONSTRAINTRULE,
  CHOICERULE,
  GENERATERULE,
  WEIGHTRULE,
  OPTIMIZERULE
} TRuleType;

/*! \var TId
		\brief Type for identifiers.
*/
typedef long int TId;

/*! \typedef TNodeSet
		\brief A std::map containing pointers to CNode. The Id of a Node is used for indexing.
*/
typedef CSet<TId, CNode*> TNodeSet;
typedef TNodeSet::value_type valType;

/*! \typedef TAtomSet
		\brief A std::map containing pointers to CAtom. The Id of an Atom is used for indexing.
*/
typedef CSet<TId, CAtom*> TAtomSet;
typedef TAtomSet::value_type valTypeAtom;

/*! \typedef TSetOfAtomSets
		\brief A std::map containing atom sets. The Id of an AtomSet is used for indexing.
*/
typedef CSet<TId, TAtomSet> TSetOfAtomSets;
typedef TSetOfAtomSets::value_type valTypeAtomSets;

/*! \typedef TRuleSet
		\brief A std::map containing pointers to CRule. The Id of a Rule is used for indexing.
*/
typedef CSet<TId, CRule*> TRuleSet;

typedef CSet<TId, TRuleSet*> TSetOfRuleSet;

typedef list<pair<string,string> > TPrefList;

typedef CSet<TId, TNodeSet*> TSetOfNodeSets;
typedef TSetOfNodeSets::value_type valTypeNodeSets;

typedef map<TId, int> TSetOfCounters;

/*! \struct TStackElement
		\brief A struct containing TId, the data and the size of the data block.

		The _ID is the identifier of a node, _Data contains the dynamic state attributes of that node
    and _Size contains the size of the _Data buffer.
*/
typedef struct{
  CNode*        _Node;              /*!< Pointer to node */
  bool          _ChoicePoint;       /*!< is this node a choice point */
  TColor        _ChoicePointColor;  /*!< with which color is the choice point colored */
  char*         _Data;              /*!< data for storing the node */
  unsigned long _Size;              /*!< size of data field */
} TStackElement;

/*! \typedef TStack
		\brief A std::stack.
*/
typedef std::stack<TStackElement> TStack;

/*! \typedef TQueue
		\brief A std::queue.
*/
typedef std::queue<CNode*> TQueue;

class CLess : public binary_function<CNode*, CNode*, bool>
{
	public:
		bool operator()(CNode* n1, CNode* n2);
};

/*! \typedef TQueue
		\brief A std::queue.
*/
//typedef TQueue TChoices;
typedef std::priority_queue<CNode*, vector<CNode*>, CLess> TChoices;

typedef list<pair<CNode*,bool> > TChoice;

//typedef std::stack<TChoice> TChoiceLists;
typedef std::stack<TNodeSet*> TChoiceLists;

// end of typedefs

/*! \class CIdGenerator
		\brief Generates unique Ids.

		CIdGenerator contains a static reference to the only allowed instance of its class.
*/
class CIdGenerator {
	private:
		static TId _id; //!< contains the last generated Id

	public:
	//! constructor
	CIdGenerator();

  //! destructor
	~CIdGenerator();

	//! Generates an unique id
	inline TId GetId() {
		return ++_id;
  };
};

} // end of NS_NOMORE

#endif
