/***************************************************************************
                          print.cpp  -  description
                             -------------------
    begin                : Fri Aug 20 2004
    copyright            : (C) 2004 by nomore-dg
    email                : nomore-dg@cs.uni-potsdam.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "print.h"

long methode_supported = 0;
long methode_unsupported = 0;
long methode_blocked = 0;
long methode_unblocked = 0;
long methode_maximal = 0;
long methode_maximal_by_set = 0;
long methode_supported_by_set = 0;
long methode_blocked_by_set = 0;

long counter_choicepoints = 0;

long methode_operator_p_call = 0;
long methode_operator_u_call = 0;
long methode_operator_v_call = 0;
long methode_operator_n_call = 0;
long methode_operator_c_call = 0;
long methode_operator_c1_call = 0;
long methode_operator_d_call = 0;
long methode_operator_pre_call = 0;
long methode_operator_prepref_call = 0;
long methode_totalcoloring = 0;
long methode_operator_ppref_call = 0;
long methode_operator_upref_call = 0;
long methode_operator_dpref_call = 0;
long methode_operator_d2pref_call = 0;
long methode_operator_dprefh_call = 0;

Timer methode_operator_p_call_time;
Timer methode_operator_u_call_time;
Timer methode_operator_v_call_time;
Timer methode_operator_n_call_time;
Timer methode_operator_c_call_time;
Timer methode_operator_c1_call_time;
Timer methode_operator_d_call_time;
Timer methode_operator_pre_call_time;
Timer methode_operator_prepref_call_time;
Timer methode_totalcoloring_time;
Timer methode_operator_ppref_call_time;
Timer methode_operator_upref_call_time;
Timer methode_operator_dpref_call_time;
Timer methode_operator_d2pref_call_time;
Timer methode_operator_dprefh_call_time;


long methode_colornode = 0;
long methode_colornode_fg = 0;

Timer _call_timer;

#ifdef _DEBUG

namespace NS_NOMORE{

CObjectCounter _object_counter;

CObjectCounter::CObjectCounter(){

}

CObjectCounter::~CObjectCounter(){

}

void CObjectCounter::CreateObject(std::string type){
  if(_count_list.find(type) != _count_list.end())
    _count_list[type].Created++;
  else
  {
    _count_list[type].Created = 1;
    _count_list[type].Deleted = 0;
  }
}

void CObjectCounter::DeleteObject(std::string type){
  if(_count_list.find(type) != _count_list.end())
    _count_list[type].Deleted++;
  else
  {
    _count_list[type].Created = 0;
    _count_list[type].Deleted = 1;
  }
}

long CObjectCounter::ObjectCount(std::string type){
  if(_count_list.find(type) != _count_list.end())
    return _count_list[type].Created-_count_list[type].Deleted;
  else
    return 0;
}

bool CObjectCounter::Clear(){
  std::map<std::string, TCounter>::iterator ite;

  for(ite = _count_list.begin(); ite != _count_list.end(); ite++)
    if((ite->second).Created != (ite->second).Deleted)
      return false;

  return true;
}

void CObjectCounter::DeleteAll(){
  _count_list.clear();
}

std::ostream& operator<<(std::ostream& os, CObjectCounter& obj){
  std::map<std::string, TCounter>::iterator ite;

  os << "Object type : created/deleted \n";
  os << "----------------------------- \n";
  for(ite = obj._count_list.begin(); ite != obj._count_list.end(); ite++)
    os << ite->first.c_str() << " : " << (ite->second).Created << "/" << (ite->second).Deleted << "\n";

  return os;
}

} // end of namespace

#endif
