%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% I/O predicates                                                          %
% Thomas Linke, Christian Anger, Katrin Konczak                           %
%                                                                         %
% last edit: Dec 28, 2000                                                 %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% lp2file(+LP,+File) is the oppisite of file2lp 
% 
%
lp2file(LP,File):-
	int2ext(LP,Ext),
	write2file(File,Ext).


%
% write2file(+File,+LP)
%
write2file(File,LP):-
	atom_string(Atom,File),
	open(Atom,write,Stream),
	write_clauses(Stream,LP),
	close(Stream).

%
% write_clauses/1
%
write_clauses( _, [] ) :- !.
write_clauses( S, [C|Clauses] ) :- 
	nl(S),write_cl(S,C),
	write(S,'.'),
	nl(S),
	write_clauses(S,Clauses).

%
% write_cl/2
%
write_cl( S, (Head :- Body) ) :-
	write_head(S,Head), write(S,':-'), nl(S),
	write_body(S,Body,9).
write_cl( S, Fact ) :-
	write(S,Fact).

%
% write_head/2
%
write_head( S,Head ) :-
	write(S,Head).	

%
% write_body/2
%
write_body( S, (A,B), Z ) :-
	write_body(S,A,Z),
	write(S,','),nl(S),
	write_body(S,B,Z).
write_body( S, (A->B;C), Z ) :-
	leer(S,Z),write(S,'('),nl(S),
	Z1 is Z+4,
	leer(S,Z1),write_body(S,A,0),write(S,' ->'),nl(S),
	leer(S,Z1),write(S,'('),nl(S),
	Z2 is Z1+4,
	write_body(S,B,Z2),nl(S),
	leer(S,Z1),write(S,');'),nl(S),
	leer(S,Z1),write(S,'('),nl(S),
	write_body(S,C,Z2),nl(S),
	leer(S,Z1),write(S,')'),nl(S),
	leer(S,Z),write(S,')').
write_body( S, (A;B), Z ) :-
	leer(S,Z),write(S,'('),nl(S),
	Z1 is Z+4,
	write_body(S,A,Z1),
	write(S,';'),nl(S),
	write_body(S,B,Z1),nl(S),
	leer(S,Z),write(S,')'). 
/* include this for output: not(Term) instead of not Term. 
write_body( S, not(A) ,Z ) :-
	leer(S,Z), 
	write(S,not),
	write(S,'('),
	write(S,A),
	write(S,')').
*/
write_body( S, A ,Z ) :-
	leer(S,Z), 
	write(S,A).

%
% leer/1
%
leer(_S,Z):-Z<1.
leer(S,Z):-
	write(S,' '),
	Z1 is Z-1,
	leer(S,Z1).



%
% int2ext/2 is oppisite of ext2int/2
%
int2ext([],[]).
int2ext([R|Rules],[O|Out]):-
	get_representation(R,O),
	int2ext(Rules,Out).


%
% get_representation gives external representation of LP
%
get_representation( rule(Head,[],[]),   Head ) :- !.
get_representation( rule(Head,Pos,Neg), Rule ) :-
	negate(Neg,NNeg),
	append(Pos,NNeg,List),
	list2term(List,Body),
	!,
	Rule = (Head:-Body).

list2term( [H], H ) :- !. 
list2term( [H|List], (H,Body) ) :- 
	list2term( List, Body ).
	
%
% negate/2
%
negate([],[]).
negate([H|T],[not(H)|NT]):-
	negate(T,NT).


