%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predicates accessing the color structure                                %
% it is assumed that the block graph is present in the prolog database    %
% (see blockgraph.pl)                                                     %
%                                                                         %
% Thomas Linke                                                            %
%                                                                         %
% last edit: Jun 2003                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Interface to color structure                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

is_1( Node, Col )  :- 
	!,is_x(Node,Col,V), V == 1.

is_2( Node, Col )  :- 
	!,is_x(Node,Col,V), V == 2.

is_0( Node, Col )  :- 
	!,is_x(Node,Col,V), V == 0.

is_i( Node, Col )  :- 
	!,is_x(Node,Col,V), V == i.

is_u( Node, Col )  :- 
	!,is_x(Node,Col,V), V == u. 


is_1_or_i( Node, Col )  :- 
	is_1(Node,Col);is_i(Node,Col).

is_2_or_i( Node, Col )  :- 
	is_2(Node,Col);is_i(Node,Col).

is_0_or_i( Node, Col )  :- 
	is_0(Node,Col);is_i(Node,Col).

is_1_or_2_or_i( Node, Col ) :-
	is_1(Node,Col); % or
	is_2(Node,Col); % or
	is_i(Node,Col).


is_u_or_2( Node, Col )  :- 
	is_u(Node,Col);
	is_2(Node,Col).

is_1_or_2( Node, Col ) :-
	is_1(Node,Col);is_2(Node,Col).

is_1_or_2_x(  Node, Col, X ) :-
	(is_1(Node,Col),X=1);(is_2(Node,Col),X=2).

is_1_or_u( Node, Col ) :-
	is_1(Node,Col);is_u(Node,Col).

is_1_or_u_x( Node, Col, X ) :-
	(is_1(Node,Col),X=1);(is_u(Node,Col),X=u).


col_i( Node, Col ) :- 
	inc_counter(coli), 
	set_x(Node,Col,i),
	show(Node,i,Col).

col_i( Node, Col ) :- 
	is_x(Node,Col,V),
	show(Node,V,Col),
        fail.

col_1( Node, Col ) :- 
	inc_counter(col1),
	set_x(Node,Col,1),
	show(Node,1,Col).

col_1( Node, Col ) :- 
	is_x(Node,Col,V),
	show(Node,V,Col),
        fail.


col_2( Node, Col ) :- 
	inc_counter(col1),
	set_x(Node,Col,2),
	show(Node,2,Col).

col_2( Node, Col ) :- 
	is_x(Node,Col,V),
        show(Node,V,Col),
        fail.


col_0( Node, Col ) :- 
	inc_counter(col0),
	set_x(Node,Col,0),
	show(Node,0,Col).

col_0( Node, Col ) :- 
	is_x(Node,Col,V),
	show(Node,V,Col),
        fail.

set_x( Node, Color, 0 ) :-
	Color = c(Col,L),       
	arg(Node,Col,C),
	!, 
	(
	    C == 0 -> true;
	    (
		C == u,
		setarg(Node,Col,0)
	    )
	).
set_x( Node, Color, 1 ) :-
	Color = c(Col,L),       
	arg(Node,Col,C),
	!, 
	(
	    C == 1 -> true;
	    (
		(C == u;C == 2),
		setarg(Node,Col,1)
	    )
	).     
set_x( Node, Color, 2 ) :-
	Color = c(Col,L),       
	arg(Node,Col,C),
	!, 
	(
	    (C == 2;C == 1) -> true;
	    (
		(C == u),    
		setarg(Node,Col,2)
	    )
	).     
set_x( Node, Color, i ) :-
	Color = c(Col,L),       
	arg(Node,Col,C),
	!, 
	(
	    C == i -> true;
	    (
		setarg(Node,Col,i)
	    )
	).     

is_x( Node, Color, C ) :-
	inc_counter(test),
	Color = c(Col,L),
	arg(Node,Col,C).


% uncolored_bodies/2 has to use is_u_or_2/3 in order to determine 
% nodes that have not been colored properly so far
%                         +    -
uncolored_bodies( Col, UBodyIds ) :-
	findall(ID,( 
	            id_b(ID,_),not(del_b(ID)),is_u_or_2(ID,Col) 
		   ),
		UBodyIds).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% compile_color/1 compiles color structure for block graph, which 
% has to be present in the prolog database
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%              -
compile_color( Color ) :-  
	init_color(B_Ids,R_Ids,H_Ids,Color,Sig).

% init_color/4 generates color structure color/n where
% n = 2 x (number of bodies + number of rules + number of heads)
% L1 is number of B_Ids
% L2 is number of R_Ids
% L3 is number of H_Ids
%           -      -      -      -   
init_color( B_Ids, R_Ids, H_Ids, c(Col,L) , Sig ) :-
%	gr_body_ids(B_Ids),
%	gr_rule_ids(R_Ids),
%	gr_head_ids(H_Ids),

	body_ids(B_Ids),
	rule_ids(R_Ids),
	head_ids(H_Ids),

	length(B_Ids,L1),
	length(R_Ids,L2),
	length(H_Ids,L3),
	Sig = sig(L1, L2, L3, L),            % form of signature
	L  is L1 + L2 + L3, 
	LL is L, 
	functor(Col,color,LL),
        ( foreacharg(C,Col) do C=u ).


