%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% commands of the noMoRe-system                                           %
%                                                                         %
% Thomas Linke                                                            %
%                                                                         %
% last edit: Aug 2003                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% nomore(+File,+N) computes N answer sets of program File                 %
% if N=0 all answer sets are computed                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       +     +
nomore( File, N1 ) :-

	(
	    get_flag(log) ->
	    (
		open('nomore.log', write, MyStream), 
		set_stream(output, MyStream)
	    );true
	),

        setval(newatom,0), 
	init_counters,	
	preprocessing(File,LPFile,Col),
	new(X),	
	!,
	writeln('computing answer sets ...'),
	(
	    N1 == 0 ->
	    (
		% all solutions
		Call = count_solutions(a_color(Col,X),N)
	    );
	    (
		% N1 solutions
		Call = count_solutions(a_color(Col,X),N1,N)
	    )
	),
	cputime(T0),
	( 
	    get_flag(profile) ->
	    (
		profile(Call)
	    );
	    (
		call(Call)
	    )
	),
	writeln('answer sets done'),
	cputime(T1),
	T is T1 - T0,
	get_counters,
	nl,
	write('number of solutions        : '),write(N),
	write('  (for program '),
	write(LPFile),writeln(')'),
	write('duration                   : '),write(T),
	writeln('s'),
	!,
	(
	    get_flag(log) -> close(MyStream); true
	),
	daVinci_stop.

%              +     +       -
preprocessing( File, LPFile, Col ) :-
	file_existence(File,LPFile),
	grounding(LPFile,GroundFile),

	write('parsing file '),write(GroundFile),writeln(' ... '),
	parse_file(GroundFile,LP1,ClasNeg),
	heuristic_sort_rule(LP1,LP2),
	writeln('parsing done'),nl,
	(
	    get_flag(capture) ->
	    (
		%write('making captured ... '),
		capture(LP2,LP),
		%writeln('done'),nl
		true
	    );LP2 = LP
	),
%	length(LP,LP_Length),	length(LP2,LP2_Length),
%	writeln(now:LP2_Length:rules),nl,
%	writeln(now:LP_Length:captured:rules),nl,
	(
	    get_flag(transformation) ->
	    (
		write('program transformation ... '),
		program_transformation(LP,LPr),
		writeln('done'),nl,
		%length(LPr,Lr),
		%writeln(now:Lr:rules:after:transformaion),nl
		true
	    );
	    (
		LP = LPr
	    )
	),
	program_database(LPr),
	compile_blockgraph,
	compile_color(Col),
	(
	    get_flag(show) -> 
	    (
		%write('generating daVinci output ... '),
		daVinci(_),
		%writeln('done'),nl
		true
	    );true
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% nomore(+File,+N1,-AnswerSets,-CP) computes N1 answer sets of program File% 
% if N=0 all answer sets are computed                                     %
% AnswerSets = list of all answer sets                                    %
% CP         = number of choice points                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       +     +   -           -
nomore( File, N1, AnswerSets, CP ) :-
	(
	    get_flag(log) ->
	    (
		open('nomore.log', write, MyStream), 
		set_stream(output, MyStream)
	    );true
	),

        setval(newatom,0), 
	init_counters,
	preprocessing_wo_output(File,Col),
	new(X),
	!,
	findall( M, (a_color(Col,X),interpret(Col,M)), AnswerSets ),
	get_counter(choice,CP).

preprocessing_wo_output( File, Col ) :-
	file_existence(File,LPFile),
	grounding(LPFile,GroundFile),

	parse_file(GroundFile,LP1,ClasNeg),
	heuristic_sort_rule(LP1,LP2),
	(
	    get_flag(capture) ->
	    (
		write('making captured'),nl,
		capture(LP2,LP),
		write('making captured done'),nl
	    );LP2 = LP
	),
	(
	    get_flag(transformation) ->
	    (
		program_transformation(LP,LPr)
	    );
	    (
		LP = LPr
	    )
	),
	program_database(LPr),writeln(LPr),
	compile_blockgraph,
	compile_color(Col).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% misc predicates for nomore/2 and nomore/4                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% count_solutions(+Goal,-N) count each solution of Goal and forget it
% N is number of solutions
%
count_solutions( Goal, _ ) :-
             setval(count, 0),
             call(Goal),
	     (
		 get_flag(output) ->
		 (
		     Goal = a_color(Col,X),
		     getval(count,N),
		     interpret_acoloring(Col,N)
		 );
		 (
		     true
		 )
	     ),
             incval(count),
             fail.
count_solutions( _, N ) :-
             getval(count, N),nl.

%
% count each solution, and forget it
% K is maximal number of solutions to be computed 
%
count_solutions( a_color(Col,X), K, N ) :-
	Goal = a_color(Col,X),
	setval(count, 0),
	call(Goal),
	incval(count),
	(
	    get_flag(output) ->
	    (
		getval(count,N),N1 is N -1,
		interpret_acoloring(Col,N1)
	    );
	    (
		getval(count,N)
	    )
	),
	(
	    write('Found solution: '),writeln(N)
	),
	(N >= K) -> true;fail.
count_solutions( _, _, _, N ) :-
	getval(count, N),nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% deal with variables                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% grounding/2 creates ground program by using some grounder 
%          +     -
grounding( File, GroundFile ) :-
	(
	    get_flag(grounder) ->
	    (   % current call to lparse (smodels grounder)
	        % lparse -t < File > File.glp
		create_call_lparse(File,Grounder_call,GroundFile),
		call_grounder(Grounder_call),
		(
		    get_flag(prolog(eclipse)) -> 
		    (
			system(Grounder_call)
		    );
		    (
			get_flag(prolog(swi)),!,
			shell(Grounder_call)
		    )
		),
		write('grounded file is '),write(GroundFile),
		nl
	    );
	    (
		GroundFile = File
	    )
	).

% create_call_lparse(+In_File,-Lparse_call,-Grounded_File)
% Lparse_call is the atom which is needed for system(Lparse_call)
create_call_lparse(In_File,Lparse_call,Grounded_File):-
	get_flag(prolog(eclipse)),!,
	build_file_name(In_File,'.glp',Grounded_File),
	concat_atoms('lparse -t < ',In_File,F1),
	concat_atoms(F1,' > ',F2),
	concat_atoms(F2,Grounded_File,Lparse_call).

create_call_lparse(In_File,Lparse_call,Grounded_File):-
	get_flag(prolog(swi)),!,
	build_file_name(In_File,'.glp',Grounded_File),
	concat_atoms('lparse -t < ',In_File,F1),
	concat_atoms(F1,' > ',F2),
	concat_atoms(F2,Grounded_File,Lparse_call).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% delete temporary files and file existence                               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear :-
	write('deleting temporary files ... '),nl,
	write('calling: rm tmp*'),nl,
	system('rm tmp*'),
	write('calling: rm *.daVinci'),nl,
	system('rm *.daVinci'),
	system('rm nomore.log'),
	write('done'),nl.

%               +     -
file_existence( File, OutFile ) :- 
	(
	    exists(File) ->
	    (
		OutFile = File
	    );
	    (
		concat_atoms(File, '.lp', LPFile),
		write('file '),write(File),write(' not found, trying file '),
		write(LPFile),nl,
		(
		    exists(LPFile) ->
		    (
			OutFile = LPFile
		    );
		    (
			write('file does not exist'),nl,!,fail
		    )
		)
	    )
	).

%
% commands dealing with flags 
%
a :- aflags.
f :- flags.

% toggle flags
red       :- toggle(reduction).
trans     :- toggle(transformation).
transSH   :- toggle(transformationSH).
transSB   :- toggle(transformationSB).
backprop  :- toggle(backprop).
metainfo  :- toggle(metainfo).
lookahead :- toggle(lookahead).
show      :- toggle(show).
capture   :- toggle(capture).
output    :- toggle(output).
%jumping   :- toggle(jumping).
ignore    :- toggle(ignore). 
names     :- toggle(names).
log       :- toggle(log).
compile   :- toggle(compile_clauses).

toggle( Flag ) :-
	( 
	    get_flag(Flag) ->
	    (
		clear_flag(Flag),!
	    );
	    (
		set_flag(Flag)
	    )
	).
