%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% system counters                                                         %
%                                                                         %
% Thomas Linke, Christian Anger                                           %
%                                                                         %
% last edit: June 2003                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% init_counters/0 initalization of all system counters with zero
%
init_counters :- 
	findall(X,valid_counter(X),Counters),
	init_counters(Counters).

init_counters( [] ) :- !.
init_counters( [C|Counters] ):-
	setval(C,0),
	init_counters(Counters).

%
% inc_counter(X) :- !. % not count 
%
inc_counter(C) :- 
	incval(C).

%
% get counter value V for counter C
%
get_counter( C, V ) :- 
	getval(C,V).

%
% set counter value for counter C
%
set_counter( C, V ) :- 
	setval(C,V).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Counter Database                                                        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
valid_counter(choice).  % choices       vs smodels
valid_counter(cp).      % choice points vs dlv
valid_counter(col1).    % assignments
valid_counter(col0).
valid_counter(coli).
valid_counter(lcol1).    % assignments during lookahead
valid_counter(lcol0).
valid_counter(test).

valid_counter(lookahead).
valid_counter(newatom).
valid_counter(newconstraintatom).
valid_counter(id).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% initial values for counters                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- set_counter(newatom,0).              % counter for atom generation
:- set_counter(newconstraintatom,0).    % counter for atom generation


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% printing counters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_counters :-
	getval(test,TEST),
	getval(col1,Col1), 
	getval(col0,Col0), 
	getval(coli,Coli), 
	getval(lcol1,LCol1), 
	getval(lcol0,LCol0), 
	Y is LCol1 + LCol0,
	X is Col1 + Col0,
	Col is X + Y,
	getval(choice,Choice),
	getval(cp,CP),
	getval(lookahead,LOOKAHEAD),
	CL is Choice + LOOKAHEAD,
	(
	    nl,
%	    write('---------------------------------------------'),nl,
%	    writeln(test:TEST),
%	    write('------- assignments -------------------------'),nl,
%	    write('col_1                         : '),write(Col1),nl,
%	    write('col_0                         : '),write(Col0),nl,
%	    write('col_i                         : '),write(Coli),nl,
%	    write('col_1 during lookahead        : '),write(LCol1),nl,
%	    write('col_0 during lookahead        : '),write(LCol0),nl,
	    write('---------------------------------------------'),nl,
	    write('total number of assignments   : '),write(Col),nl,
%	    write('---------------------------------------------'),nl,
%	    write('------- choices and choice points -----------'),nl,
	    write('total number of choices       : '),write(Choice),nl,
%	    write('choices during lookahead      : '),write(LOOKAHEAD),nl,
%	    write('total number of choice points : '),write(CP),nl,
	    write('---------------------------------------------'),nl,
%	    write('total number of choices       : '),write(CL),nl,
%	    write('---------------------------------------------'),nl,
	    true
	).
