%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% predicates for file access % % % % Thomas Linke % %
% % last edit: June 2002 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% compile_clauses(+Clauses,+File) compiling clauses
%
compile_clauses( Clauses, File ) :-
	(
	    get_flag(prolog(eclipse)) ->
	    (
		get_flag(compile_clauses) ->
		(
		    atom_string(Atom,File),
		    open(Atom,write,Stream),!,
		    write_clauses(Stream,Clauses),
		    close(Stream),!,
		    compile_term(Clauses) 
		);
		(
		    compile_term(Clauses) 
		)
	    );
	    (
		atom_string(Atom,File),
		open(Atom,write,Stream),!,
		write_clauses(Stream,Clauses),
		close(Stream),!,
		ensure_loaded(Atom)
	    )
	).

%
% write_clauses/1
%
write_clauses( _, [] ) :- !.
write_clauses( S, [C|Clauses] ) :- 
	nl(S),write_cl(S,C),
	write(S,'.'),
	nl(S),
	write_clauses(S,Clauses).

%
% write_cl/2
%
write_cl( S, (Head :- Body) ) :-
	write_head(S,Head), write(S,':-'), nl(S),
	write_body(S,Body,9).
write_cl( S, Fact ) :-
	writeq(S,Fact).

%
% write_head/2
%
write_head( S,Head ) :-
	writeq(S,Head).	

%
% write_body/2
%
write_body( S, (A,B), Z ) :-
	write_body(S,A,Z),
	write(S,','),nl(S),
	write_body(S,B,Z).
write_body( S, (A->B;C), Z ) :-
	space(S,Z),write(S,'('),nl(S),
	Z1 is Z+4,
	space(S,Z1),write_body(S,A,0),write(S,' ->'),nl(S),
	space(S,Z1),write(S,'('),nl(S),
	Z2 is Z1+4,
	write_body(S,B,Z2),nl(S),
	space(S,Z1),write(S,');'),nl(S),
	space(S,Z1),write(S,'('),nl(S),
	write_body(S,C,Z2),nl(S),
	space(S,Z1),write(S,')'),nl(S),
	space(S,Z),write(S,')').
write_body( S, (A;B), Z ) :-
	space(S,Z),write(S,'('),nl(S),
	Z1 is Z+4,
	write_body(S,A,Z1),
	write(S,';'),nl(S),
	write_body(S,B,Z1),nl(S),
	space(S,Z),write(S,')'). 
/* include this for output: not(Term) instead of not Term. 
write_body( S, not(A) ,Z ) :-
	space(S,Z), 
	write(S,not),
	write(S,'('),
	write(S,A),
	write(S,')').
*/
write_body( S, A ,Z ) :-
	space(S,Z), 
	writeq(S,A).

%
% space/2
%
space(_S,Z):-Z<1.
space(S,Z):-
	write(S,' '),
	Z1 is Z-1,
	space(S,Z1).


