%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The noMoRe-System Version: 1.0                                          %
%                                                                         %
% Thomas Linke, Christin Anger, Kathrin Konczak, Andreas Boesel           %
%                                                                         %
% last edit: June 2003                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% consulting source code                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:- ensure_loaded(flags).

%
% configuration of noMoRe and default flag setting
%

%
:- set_flag(prolog(eclipse)).

degree(1).

%
% consult Prolog system specific code
%
:- (   % eclipse 
	ensure_loaded('eclipse.pl'),
	ensure_loaded(library(ordset)),
	import(ordset),
	ensure_loaded(library(strings)),
	ensure_loaded(library(sorts)),
	ensure_loaded(library(profile)),
	ensure_loaded(library(lists)),
	set_flag(variable_names,off)
    ).

:- ensure_loaded('show.pl').           % daVinci interface
:- ensure_loaded('daVinci.pl').        % output of block graph

:- ensure_loaded('io.pl').
:- ensure_loaded('counters.pl').
:- ensure_loaded('commands.pl').
:- ensure_loaded('rules.pl').
:- ensure_loaded('lists.pl').
:- ensure_loaded('answersets.pl').     % get answer sets

:- ensure_loaded('parser.pl').         % parser
:- ensure_loaded('database.pl').       % program database for normal NLP
:- ensure_loaded('transformation.pl'). % program transformations
:- ensure_loaded('blockgraph.pl').     % max_grounded and block graph
:- ensure_loaded('reduction.pl').      % graph reductions
:- ensure_loaded('color.pl').          % color structure
:- ensure_loaded('algorithm.pl').      % a-colorings
:- ensure_loaded('heuristic.pl').      % heuristic choose


:- nl,f. % show flag settings 
