%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% interface rule format, gives access to different parts of rule R        %
%                                                                         %
% Thomas Linke, Christian Anger                                           %
%                                                                         %
% last edit: June 2002                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% R = rule(Name,Head,Bodies) where Bodies is list of normal bodies B
% B = body(P,N) is normal body where P is list of positive body atoms 
%                              and   N is list of negative nody atoms
%
rule_head(rule(Heads,_,_),Heads).
rule_body(rule(_,Bodies,_),Bodies).
rule_name(rule(_,_,Name),Name).
rule_body_head_name(R,Body,Head,Name) :-
	rule_body(R,Body),
	rule_head(R,Head),
	rule_name(R,Name).
%
% access to positiv and negative parts of normal bodies
% 
pos_body(body(P,_),P).
neg_body(body(_,N),N).

body_pos(R,P) :- pos_body(R,P).
body_neg(R,P) :- neg_body(R,P).

%
% access to different subsets of rules
%
all_fact_rules( [], [] ).
all_fact_rules( [R|Rs], [R|Rest] ) :-
	fact_rule(R),!,
	all_fact_rules(Rs,Rest).
all_fact_rules( [_|Rs], Rest ) :-
	all_fact_rules(Rs,Rest).

all_q_fact_rules( [], [] ).
all_q_fact_rules( [R|Rs], [R|Rest] ) :-
	q_fact_rule(R),!,
	all_q_fact_rules(Rs,Rest).
all_q_fact_rules( [_|Rs], Rest ) :-
	all_q_fact_rules(Rs,Rest).

%
% classification of rules
% 
normal_rule( Rule ) :-
	rule_body(Rule,Body),
	rule_head(Rule,Head),
	Body = [_],
	Head = [_].

fact_rule( Rule ) :-
	rule_body(Rule,Body),
	Body = [B],
	pos_body(B,[]),
	neg_body(B,[]).
% or empty body
fact_rule( Rule ) :-
	rule_body(Rule,Body),
	Body = [].

q_fact_rule( Rule ) :- 
	rule_body(Rule,Body),
	exist_neg_body(Body).

exist_neg_body( [B|Bs] ) :-
	negative(B);exist_neg_body(Bs).
	
negative( Body ) :-
	pos_body(Body,[]),
	neg_body(Body,[_|_]).


loop_1_rule( Rule ) :- 
	rule_body(Rule,Body),
	rule_head(Rule,Head),
	exist_loop_1_body(Body,Head).

exist_loop_1_body( [B|Bs], Head ) :-
	loop_1_body(B,Head);exist_loop_1_body(Bs,Head).
	
loop_1_body( Body, Head ) :-
	neg_body(Body,NBs),
	ord_intersect(NBs,Head).


%
% test classification
%
write_normal([]):- nl,!.
write_normal([R|Rest]):-normal_rule(R),writeln(R),write_normal(Rest).
write_normal([R|Rest]):-write_normal(Rest).

write_q_fact_rule([]):- nl,!.
write_q_fact_rule([R|Rest]):-q_fact_rule(R),writeln(R),write_q_fact_rule(Rest).
write_q_fact_rule([R|Rest]):-write_q_fact_rule(Rest).

write_fact_rule([]):- nl,!.
write_fact_rule([R|Rest]):-fact_rule(R),writeln(R),write_fact_rule(Rest).
write_fact_rule([R|Rest]):-write_fact_rule(Rest).

write_loop_1_rule([]):- nl,!.
write_loop_1_rule([R|Rest]):-loop_1_rule(R),writeln(R),write_loop_1_rule(Rest).
write_loop_1_rule([R|Rest]):-write_loop_1_rule(Rest).
