%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Interface to DaVinci for interactive coloring of grpah                  %
%                                                                         %
% author: Andreas Bsel                                                   %
%                                                                         %
% last edit: Sep 2002                                                     %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

:-ensure_loaded(library(util)).
:-import(util).
:-dynamic(stopping_flag/1).
:-dynamic(eclipse_mode/0).
:-dynamic(menu_struc/1).
:-dynamic(get_menu/2).
:-dynamic(pause/1).

% ATTENTION!!! NOde and ID confused!!!!!!!!!!!!
show_coloring(ID,Color,Col) :-
	(
	    get_flag(metainfo) -> 
	    (
		process_coloring(ID,Color,Col)
	    );
            (
              id_rule(ID,_,_) ->
	     process_coloring(ID,Color,Col);true
	    )
	).

process_coloring( ID, Color, _Col ) :-
	api_focusing(ID),
	show_daVinci_color(Color,C),
	blinking(1,ID,C),
%	write('faerbe '),write(ID),write(' mit '),write(Color),
%	nl,  %Pause besser machen
	(
	    stopping_flag(every_node) ->
	    (	
		(
		    stopping_flag(choicepoints) ->
		    (
			retract(stopping_flag(every_node))
		    );true
		),
		daVinci_abfrage
	    );true
	).

%process_coloring( S, ID, Node, Color, Col ) :-
%	is_x(ID,Col,V), Ermittlung der Farbe in color.pl
%	show_daVinci_Color(Color,C),
%	do_coloring(ID,C).





do_coloring(ID,Color):-
	daV_begin,
	daVinci_db(Color,Col),
	daV_node_attribute(ID,'COLOR',Col),
	daV_end,!.

blinking(0,ID,Color):- 
	do_coloring(ID,Color).

blinking(N,ID,Color):-
	M is N-1,
	pause(Float),
	do_coloring(ID,Color),
	sleep(Float),
	do_coloring(ID,white),
	sleep(Float),
	blinking(M,ID,Color),!.


daVinci_CP(ID):-
	api_focusing(ID),
	daV_begin,
	daVinci_db(double,Border),
	daV_node_attribute(ID,'BORDER',Border),	
	daV_end,
	(
	    stopping_flag(choicepoints) ->
	    (	
		asserta(stopping_flag(every_node))
	    );
	    (
		true
	    )
	).

daVinci_CP(ID):-               %arbeiten auf Bodies
	daV_begin,
	daVinci_db(single,Border),
	daV_node_attribute(ID,'BORDER',Border),
	daV_end,fail.


daVinci_start(BlockGraph):-
	term_string(BlockGraph,String),
	da,
	da('graph(new(%w))',String),

	api_create_icon(go,"go.xbm","go"),
	api_activate_icons([go]),
	asserta(stopping_flag(every_node)),

	init_animation_speed,
	
	init_menu,
	menu_struc(MenuStruc),
	api_create_menu(MenuStruc),
	get_all_menu_IDs(MenuStruc,IDs),
	api_activate_menus(IDs).


daVinci_start(_):-
	write('Error 112: daVinci Error, clear_flag(show), abort'),nl,
	clear_flag(show),abort.

daVinci_abfrage:-
        abfrage_daVIn.
       	
abfrage_daVIn:-
        read_string(daVIn, end_of_line, _, Reply),
	(
	    substring(Reply, "program", 1) ->
	    (
		writeln('Error 113: Some of your layout changes might have
	        caused an daVinci error. clear_flagg(show), abort'),
		clear_flag(show),abort
	    );true
	),
	convert_reply(DVCommand,DV_ArgumentL,Reply),
	api_answer(Command,DVCommand,ArgType),
	do(Command,DV_ArgumentL,ArgType,A).


abfrage_user:-
	read_line(user,Reply),
	do_user_command(Reply).

do_user_command(Reply):-               %application continues
	term_string(go,Reply),!.
do_user_command(Reply):-               %calls a goal  
	term_string(Term,Reply),
	term_variables(Term,List),
	Term,
	write(List),!,
	daVinci_abfrage.

do_user_command(Reply):-               %goal failed  
	abfrage_user.

 daVinci_stop:-
	daV_exit.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  API Answers DataBase  
%%
%%  api_answer(Command,Reply,ArgumentType)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

api_answer(icon,Reply,string):- atom_string(icon_selection,Reply),!.
api_answer(popup,Reply,twoIds):-atom_string(popup_selection_node,Reply),!.
api_answer(menu,Reply,string):- atom_string(menu_selection,Reply),!.
api_answer(select,Reply,list_Id):- atom_string(node_selections_labels,Reply),!.
api_answer(dav_error,Reply,string):- atom_string(communication_error,Reply),!.
api_answer(ok,Reply,nil) :- atom_string(ok,Reply),!.

%%Fehlerabfang
api_answer(A,Reply,nil):-atom_string(A,Reply).

%%%%
%%%% Verarbeitung der DaVinci - Antworten
%%%%
convert_reply(DV_Command,DV_ArgumentL,Reply):-
	split_string(Reply,"(",")\"",List),
	List = [DV_Command|DV_ArgumentL].
%%Konvertierung der verschiedenen DV-Argument-Typen

convert_arg(_,nil,[]).

convert_arg([DV_Argument],string,DV_Argument).

convert_arg([DV_Argument],twoIds,ArgumentL):- 
	split_string(DV_Argument,",","\"",ArgumentL).

convert_arg([DV_Argument],list_Id,ArgumentL):-
	split_string(DV_Argument,",","[]\"",ArgumentL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  Action DataBase
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

do(Command,DV_ArgumentL,ArgType,Marked_Nodes):-
	convert_arg(DV_ArgumentL,ArgType,Argument),
	action(Command,Argument,Marked_Nodes).


%%%%% Mainaction Types

action(daV_error,_,_):- !,write("Syntaxfehler des API Kommandos"),nl.


action(menu,DV_Argument,Marked_Nodes):-!,
	atom_string(Menu_ID,DV_Argument),
	get_submenu(Menu_ID,Submenu_ID),
	menu_action(Menu_ID,Submenu_ID,Marked_Nodes).


action(icon,DV_Argument,Marked_Nodes):- !,
	atom_string(IconID,DV_Argument),
	action2(IconID,Marked_Nodes).


action(popup,[DV_ID,DV_Menu_ID],Marked_Nodes):-!,
	append_strings(DV_ID,DV_Menu_Type,DV_Menu_ID),
	atom_string(Menu_Type,DV_Menu_Type),
	action2(Menu_Type,DV_ID,Marked_Nodes).

%%%%%%%Fehlerabfang	

action(_,_,A):- daVinci_abfrage.


%%%%%%popup actions   (Schummel)

action2(Menu_Type,DV_ID,Marked_Nodes):-!,
%	substring(DV_ID,1,1,DV_Type),
	number_string(ID,DV_ID),
	get_Term_Type(ID,Menu_Type,Term_Type),
	node_change(ID,_,Term_Type),
	daVinci_abfrage.

%%lower praedicates for action2

change_nodes([],[],_).
change_nodes([Node_ID|Rest],FullIDList,Term_Type):-
	node_change(Node_ID,_,Term_Type),
	change_nodes(Rest,FullIDList,Term_Type).
change_nodes([],[Full_ID|Rest],Term_Type):-
	node_change(_,Full_ID,Term_Type),
	change_nodes([],Rest,Term_Type).


node_change(Node_ID,Full_ID,Term_Type):-
	daV_begin,
        number_string(Node_ID,DV_ID),
	daVinci_id2(Term_Type,Node_ID,FullRuleTerm,_),  %No new Id accepted
	get_DV_label(FullRuleTerm,DV_label),
	daVinci_db(object,Object),
	daV_node_attribute(DV_ID,Object,DV_label),
	daV_end.

get_DV_label(RuleTerm,DV_label):-           %Using nomore IDs
	integer(RuleTerm),
	number_string(RuleTerm,DV_label).   
get_DV_label(RuleTerm,DV_label):-
	\+integer(RuleTerm),
	term_string(RuleTerm,DV_label).

get_Term_Type(ID,hide,rule):-id_rule(ID,_,_),!.
get_Term_Type(ID,hide,body):-id_b(ID,_),!.
get_Term_Type(ID,hide,head):-id_h(ID,_),!.

get_Term_Type(ID,show,rule_full):-id_rule_full(ID,_,_),!.
get_Term_Type(ID,show,body_full):-id_b(ID,_),!.
get_Term_Type(ID,show,head_full):-id_h(ID,_),!.
	


%%%%%%Icon actions

action2(go,_):- !,true.

%%%%%%Menu actions

menu_action(abort,none,M):-
	daVinci_stop,
	abort.

menu_action(go,none,M).
menu_action(eclipse_mode,none,M):-
	asserta(eclipse_mode),
	daVinci_abfrage.

menu_action(stop_C,stop,Marked_Nodes):-!,    %stop at choicepoints
	retract_all(stopping_flag(A)),
	asserta(stopping_flag(choicepoints)),
	daVinci_abfrage.

menu_action(stop_E,stop,Marked_Nodes):-!,    %stop at every node
	retract_all(stopping_flag(A)),
	asserta(stopping_flag(every_node)),
	daVinci_abfrage.

menu_action(stop_F,stop,Marked_Nodes):-!,    %stop at full colorings
	retract_all(stopping_flag(A)),
	daVinci_abfrage.

menu_action(stop_N,stop,Marked_Nodes):-!,   %nostop
	retract_all(stopping_flag(A)),
	asserta(stopping_flag(nostop)),
	daVinci_abfrage.

menu_action(Style,show_nodes,_):-!,
%	rule_ids(IDs),
	presentation(Style),
	api_improve_all,
	daVinci_abfrage.

menu_action(Speed,animation,_):-!,
	get_speed(Speed,Float),
	set_speed(Float),
	daVinci_abfrage.

menu_action(Flag,flags,_):- daVinci_abfrage.


%% Hilfspraedikat fuer menu_action(Styl...)
presentation(all):-!,
        rule_ids(IDs),
	change_nodes(IDs,[],rule),
	(
	    get_flag(metainfo) ->
	    (
		head_ids(Heads),
		body_ids(Bodies),
		change_nodes(Heads,[],head),
		change_nodes(Bodies,[],body)
	    );true
	).

presentation(all_full):-!,
	rule_ids(IDs),
	change_nodes(IDs,[],rule_full),
	(
	    get_flag(metainfo) ->
	    (
		head_ids(Heads),
		body_ids(Bodies),
		change_nodes(Heads,[],head_full),
		change_nodes(Bodies,[],body_full)
	    );true
	).
presentation(Style):-
	get_style_ids(Style,IDs),
	change_nodes(IDs,[],Style).
get_style_ids(rule,IDs):-
	rule_ids(IDs).
get_style_ids(rule_full,IDs):-
	rule_ids(IDs).
get_style_ids(body,IDs):-
	body_ids(IDs).
get_style_ids(head,IDs):-
	head_ids(IDs).
get_style_ids(body_full,IDs):-
	body_ids(IDs).
get_style_ids(head_full,IDs):-
	head_ids(IDs).
	
presentation(Style,IDs):-
	change_nodes(IDs,[],Style).
	
%action2(select_neighbours,Marked_Nodes):-!,
%	get_Neighbours(Marked_Nodes,Neighbours),
%	idList_DV_idList(Neighbours,DV_Neighbours),
%	api_select_nodes(DV_Neighbours),
%	daVinci_abfrage.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%  API Commands                                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

api_select_nodes(IDs):-
	idList_DV_idList(IDs,DV_IDs),
	da('special(select_nodes(%w))', [DV_IDs]).

api_create_icon(ID,File,Text):-
	da('app_menu(create_icons([icon_entry("%w","%w","%w")]))',
                                                    [ID,File,Text]).
	
api_activate_icons(IDs):-
        idList_DV_idList(IDs,ID),
	da('app_menu(activate_icons(%w))',[ID]).


api_create_menu(MenuStruc):-
	menu_DVMenu(MenuStruc,DV_Menu),
	da('app_menu(create_menus(%w))',[DV_Menu]).
	
api_activate_menus(IDs):-
        idList_DV_idList(IDs,ID),
	da('app_menu(activate_menus(%w))',[ID]).

api_popup_menus(Node,Menus):-
	termL_2_stringL(Menus,Menus2),
	stringL_2_string(Menus2,String),
        da('graph(change_attr([node("r4",[m(%w)])]))',[String]).

api_improve_all:-
	da('menu(layout(improve_all))').

api_focusing(ID):-
	term_string(ID,String),
	da('special(focus_node_animated("%w"))',String).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Konvertierung von daVinci Strings (z.B Liste ausgewaehlter Knoten) 
% in Prolog-terme
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%% M E N U Datenbank%%%%%%%%%%%%%%%%%

%% menu_entry_mne(DV_ID,Label,KeybordUse,Shortcut,Shortcut)
get_menu(menu(abort),menu_entry_mne("abort","Abort","e",alt,"a")).
get_menu(menu(go),menu_entry_mne("go","Go","g",alt,"g")).
get_menu(menu(eclipse_mode),menu_entry_mne("eclipse_mode","Prolog mode","r",alt,"p")).


%%% Menu Stopping criterion
get_menu(sub_menu(stop),
	submenu_entry_mne("stop","Stopping criterion",
	[menu(stop_C),menu(stop_E),menu(stop_F),menu(stop_N)],"s")).

get_menu(menu(stop_E),
	menu_entry_mne("stop_E","Stop at every node","e",none,"")).

get_menu(menu(stop_C),
	menu_entry_mne("stop_C","Stop at choicepoints","c",none,"")).
	
get_menu(menu(stop_F),
	menu_entry_mne("stop_F","Stop at full coloring","f",none,"")).

get_menu(menu(stop_N),
	menu_entry_mne("stop_N","No stop","n",none,"")).


%%%%%Menu presentation
get_menu(sub_menu(show_nodes),
	submenu_entry_mne("show_nodes","Node presentation",
	[menu(all_full),menu(all),
	 menu(rule_full),menu(rule),
	 menu(body_full),menu(body),
	 menu(head_full),menu(head)],"p")).

get_menu(menu(all_full),
	menu_entry_mne("all_full","Show all","a",alt,"s")).
get_menu(menu(all),
	menu_entry_mne("all","Hide all","l",alt,"h")).
get_menu(menu(rule_full),
	menu_entry_mne("rule_full","Show rules","r",none,"")).
get_menu(menu(rule),
	menu_entry_mne("rule","Hide rule","u",none,"")).
get_menu(menu(body_full),
	menu_entry_mne("body_full","Show body","b",none,"")).
get_menu(menu(body),
	menu_entry_mne("body","Hide body","o",none,"")).
get_menu(menu(head_full),
	menu_entry_mne("head_full","Show head","h",none,"")).
get_menu(menu(head),
	menu_entry_mne("head","Hide head","e",none,"")).

%%% Menu Animation
get_menu(sub_menu(animation),
	submenu_entry_mne("animation","Animation speed",
	[menu(slow),menu(normal),
	 menu(fast)],"n")).
get_menu(menu(slow),
	menu_entry_mne("slow","slow","s",none,"")).
get_menu(menu(normal),
	menu_entry_mne("normal","normal","n",none,"")).
get_menu(menu(fast),
	menu_entry_mne("fast","fast","f",none,"")).


activated_menu(rule_full,metainfo) :- activate_possible.
activated_menu(rule,metainfo) :- activate_possible.
activated_menu(body_full,metainfo) :- activate_possible.
activated_menu(body,metainfo) :- activate_possible.
activated_menu(head_full,metainfo) :- activate_possible.
activated_menu(head,metainfo) :- activate_possible.
activated_menu(rule_full,metainfo) :- activate_possible.
activated_menu(stop_C,metainfo):-!.
activated_menu(all_full,show):- activate_possible.
activated_menu(A,show).

activate_possible :-
	!,
	not(get_flag(reduction)),
	not(get_flag(transformation)).

init_menu:-
	init_flagmenu(Flags),
	assert(get_menu(sub_menu(flags),
	submenu_entry_mne("flags","Flag info",Flags,"f"))),

	assert(menu_struc([menu(abort),menu(go),sub_menu(stop),
	                   sub_menu(show_nodes),sub_menu(animation),
			   sub_menu(flags)])).



%% Initialisierung des Flagmenus

init_flagmenu(FlagMenus):-
	findall(X,(valid_flag(X),show_flag(X)),Flags),
	create_flag_menus(Flags,FlagMenus,[],65).

create_flag_menus([],[],_,_).
create_flag_menus([Flag|Rest],[menu(Flag)|MenuRest],CharList,N):-
	create_single_flag_menu(Flag,CharList,N,NewCharList,M),
	create_flag_menus(Rest,MenuRest,NewCharList,M).
	
create_single_flag_menu(Flag,Charlist,N,[Char|Charlist],M):-
	atom_string(Flag,SFlag),
	(
	    get_flag(Flag) ->
	    (
		append_strings(SFlag,": On",Label)
	    );
	    (
		append_strings(SFlag,": Off",Label)
	    )
	),
	string_list(SFlag,[E,C|Rest]),                     %Schummel
	char_int(ZwChar,C),
	(
	    member(ZwChar,Charlist) ->
	    (
		char_int(NewChar,N),
		M is N+1,
		Char=ZwChar
	    );	
	    (
		Char=ZwChar,
		M is N
	    )
	),

	assert(get_menu(menu(Flag),menu_entry_mne(SFlag,Label,Char,none,""))).




%% preadikate zur Menuverwaltung

get_submenu(Menu_ID,Submenu_ID):-
	get_menu_list(sub_menu(Submenu_ID),List),
	member(menu(Menu_ID),List),!.
get_submenu(_,none).

get_menu_list(sub_menu(A),List):-
	get_menu(sub_menu(A),submenu_entry_mne(_,_,List,_)).

get_all_menu_IDs([],[]).
get_all_menu_IDs([menu(ID)|Rest],[ID|RestIDs]):-
	activated_menu(ID,Flag),
	get_flag(Flag),
	get_all_menu_IDs(Rest,RestIDs).

get_all_menu_IDs([menu(ID)|Rest],RestIDs):-
	get_all_menu_IDs(Rest,RestIDs).

get_all_menu_IDs([sub_menu(ID)|Rest],[ID|Erg]):-
	get_menu_list(sub_menu(ID),List),
	get_all_menu_IDs(List,Erg1),
	get_all_menu_IDs(Rest,Erg2),
	append(Erg1,Erg2,Erg).

convertmnu([],[]).
convertmnu([menu(ID)|Rest],[D|NRest]):-

	get_menu(menu(ID),D),
	convertmnu(Rest,NRest).

convertmnu([sub_menu(ID)|Rest],[submenu_entry_mne(A,B,DV_MenuList,X)|NRest]):-
	get_menu(sub_menu(ID),submenu_entry_mne(A,B,MenuList,X)),
	convertmnu(MenuList,DV_MenuList),
	convertmnu(Rest,NRest).
	
menu_DVMenu(MenuStruc,DV_Menu):-
	convertmnu(MenuStruc,Zw),
	term_string(Zw,DV_Menu).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                          %
%  Animation - Datenbank und Praedikate                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

get_speed(slow,0.3).
get_speed(normal,0.07).
get_speed(fast,0.01).

get_speed(Float):-
	pause(Float).
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % Praedikat zum aendern der Animationsgeschwindigkeit                     %
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   set_speed(Float):-
	float(Float),!,
	retract_all(pause(A)),
	assert(pause(Float)).
   set_speed(Float):-
	write("Type error: real number wanted"),nl.


   init_animation_speed:-
	(
	    pause(Float) ->
	    set_speed(Float);set_speed(0.07)
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Ende%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  idList_DV_idList wandelt eine Liste von prolog-atomen in einen String um, der die Liste so darstellt,
%  dass alle Listenelemente in Anfuehrungsstrichen stehen.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

idList_DV_idList(IDs,StringIDs):-
	idList_DV_idList(IDs,"",Zw1),
	append_strings("[",Zw1,Zw2),
	append_strings(Zw2,"]",StringIDs).
	

idList_DV_idList([],StringIDs,StringIDs).

idList_DV_idList([ID],ZwString1,StringIDs):-
	!,
	atom_string(ID,IDstr),
	atom_string('"',X),
	append_strings(X,IDstr,A),
	append_strings(A,X,SingleStr),
	append_strings(ZwString1,SingleStr,StringIDs).
	
idList_DV_idList([ID|IDs],ZwString1,StringIDs):-
	atom_string(ID,IDstr),
	atom_string('"',X),
	append_strings(X,IDstr,A),
	append_strings(A,X,SingleStr),
	append_strings(SingleStr,",",E),
	append_strings(ZwString1,E,ZwString2),
	idList_DV_idList(IDs,ZwString2,StringIDs).



termL_2_stringL([],[]).

termL_2_stringL([Term|Terms],[String|LastStr]):-
	term_string(Term,String),
	termL_2_stringL(Terms,LastStr).

stringL_2_string(StringL,String):-
	stringL_2_string(StringL,"",EString),
	append_strings("[",EString,Zwerg),
	append_strings(Zwerg,"]",String).


stringL_2_string([],String,String).

stringL_2_string([Single],ZwString1,String):-
	!,
	append_strings(ZwString1,Single,String).
	
stringL_2_string([Single|Rest],ZwString1,String):-
	append_strings(Single,",",E),
	append_strings(ZwString1,E,ZwString2),
	stringL_2_string(Rest,ZwString2,String).

%%%%%%%%%%%%%%%%%% Fuer Testzwecke  %%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Da das Modul mydavinci.pl (abgeaenderte daVinci Library) kein CVS-
%
%  Dokument ist, integrier ich den Quelltext an dieser Stelle             
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

daV_begin:-
	(current_stream(daVOut) ->
	    true
	;
	    da
	),
	setval(daVOut,0),
	setval(daVEdge,0),
	setval(daVAttribute,0),
	open(string(""),write,daVEdge),
	open(string(""),write,daVAttribute),
	printf(daVOut,'graph(update([',[]),
        (
	    true
        ;
	    daV_end,
	    fail
	).


daV_end:-
	current_stream(daVEdge),
	get_stream_info(daVEdge,name,Edge),
	close(daVEdge),
	get_stream_info(daVAttribute,name,Attribute),
	close(daVAttribute),
	da('],[%s]))',[Edge]),
        % comment next line out to check without attributes
	da('graph(change_attr([%s]))',[Attribute]), 
        true.


daV_exit :-
	da('menu(file(exit))'),
	close(daVOut),
	( current_stream(daVIn) ->
	    da_ack	% pipe case
	;
	    true	% socket case
	).



daV_node(Node):-
	daV_node(Node,Node).



daV_node(Node,Info):-
	da_comma(daVOut),
	printf(daVOut,'new_node("%w","",[a("OBJECT","%w")])',[Node,Info]).



daV_edge(Name,Node1,Node2):-
	da_comma(daVEdge),
	printf(daVEdge,'new_edge("%w","",[],"%w","%w")',[Name,Node1,Node2]).



daV_node_attribute(Node,Type,Value):-
	da_comma(daVAttribute),
	printf(daVAttribute,'node("%w",[a("%w","%w")])',[Node,Type,Value]).


daV_edge_attribute(Node,Type,Value):-
	da_comma(daVAttribute),
	printf(daVAttribute,'edge("%w",[a("%w","%w")])',[Node,Type,Value]).



/****************************************************************************

low level interface for DaVinci

****************************************************************************/

da_comma(Stream):-
	getval(Stream,0),
	!,
	setval(Stream,1).
da_comma(Stream):-
	printf(Stream,',',[]).


da:-
	get_flag(hostarch,Arch),
	Arch = "i386_nt",
	!,
	da_executable(Executable),
	exec([Executable,'-server'],[],_P),
	socket(internet,stream,daVOut),
	get_flag(hostname, HostString),
	atom_string(Host, HostString),
	once (
	    % we might have to wait for daV to get ready to accept
	    between(1, 10, 1, _),	% try max 10 times
	    sleep(0.5),
	    block(connect(daVOut,Host/2542), _Tag,
	    	(writeln(error, "retrying ..."), fail))
	),
	set_stream(daVIn,daVOut),
	da_ack.
da:-
	da_executable(Executable),
	exec([Executable,'-pipe'],[daVOut,daVIn],_P),
	da_ack.

da_executable(Executable) :-
	getenv("DAVINCIHOME", DAVINCIHOME_OS),
	os_file_name(DAVINCIHOME, DAVINCIHOME_OS),
	(
	    concat_string([DAVINCIHOME,"/bin/daVinci"], Executable)
	;
	    concat_string([DAVINCIHOME,"/daVinci"], Executable)
	),
	existing_file(Executable, ["",".exe"], [executable], _),
	!.


da(X):-
	printf(daVOut,X,[]),
	put(daVOut,10),
	flush(daVOut),
	da_ack.

da(X,Y):-
	printf(daVOut,X,Y),
	put(daVOut,10),
	flush(daVOut),
	da_ack.

da_ack:-
	( read_string(daVIn, end_of_line, _, Reply) ->
	    ( substring(Reply, "communication_error", 1) ->
		printf(warning_output, "daVinci: %w%n", [Reply])
	    ;
		true
	    )
	;
	    close(daVIn)	% end of file
	).
