hier.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% algorithm for coloring block graphs                                     %
% [B --> R --> h -0/1-> B]  rule-based since Bs are choices               %
%                                                                         %
% Thomas Linke                                                            %
%                                                                         %
% last edit: Jul 2003                                                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% interface to extra argument X = (In,Out)                                %
% X contains extra input/output variables                                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

in(  (In,_  ), In  ).
out( (_ ,Out), Out ).
new( (_ ,_  ) ).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% the algotithmic code                                                    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% a_color/2 computes a-coloring of block graph 
% is is assumed that block graph is compiled into Prolog database
% a_color/2 goes through the cycle b(ody)->rule->h(ead) starting with b 
% that is, for normal logic programs a_color/2 deals bodies/rules 
% as main objects
%        +    ?
a_color( Col, X ) :-
	pre_color(Col,CP,X),      
	!,
	color_level(CP,Col,X).

% pre_color/3 
%          +    -   +
pre_color( Col, CP, X ) :-
	facts(F),
	q_facts( QF ),
	color_all_1_b(forw,F,Col,QF,CP1,X), 
	loops_1(L1),
	color_all_0_b(forwback,L1,Col,CP1,CP2,X),
	sort(CP2,CP).

% color_level/3
color_level( CP, Col, X ) :-
	(CP == [] -> true;
	    (
		inc_counter(cp)
	    )
	),
	color_cp(CP,Col,[],Next0,X),
	(    
	    (CP == Next0) -> 
	    (
		color_level_end(Col,X)
	    );
	    (
		color_level(Next0,Col,X)
	    )
        ).

% color_level_end/2
color_level_end( Col, X ) :-
	!,
	uncolored_bodies(Col,UBodyIds),
	(
	    UBodyIds =[] -> 
	    (	get_flag(show) ->
		daVinci_abfrage;true
	    );
	    (
		%writeln('color_level_end reached ':UBodyIds),
		(
		    color_all_0_b(forw,UBodyIds,Col,[],[],X) ->
		    (
			get_flag(show) ->      %stop bei voller Faerbung
			daVinci_abfrage;true
		    );
		    (
			%writeln('color_level_end failed'),
			(
			    get_flag(show) ->
			    daVinci_abfrage;true
			),
			!,fail
		    )
		)
	    )
	),!.

% color_cp/4
color_cp( CP, Col, Next1, Nextx, X ) :-
	heuristic_choose(Node,CP,CP1,Col,Next1,Next2), 
	(
	    Node = no ->
	    (
		!,Nextx = Next2,
		in(X,In),out(Y,In)
	    );
	    (
		id_b(Node,BBB),
		cp(Node,Col,Next2,Next3,X),
		color_cp(CP1,Col,Next3,Nextx,X)
	    )
	).

% choices
cp( Node, Col, Next1, Nextx, X ) :-
	inc_counter(choice),
	(
	    (get_flag(show),get_flag(metainfo)) ->
		(
		    daVinci_CP(Node)
		);true
	),
	col_1(Node,Col),
	prop_1_b(cp,Node,Col,Next1,Nextx,X).

cp( Node, Col, Next1, Nextx, X ) :-
	(
	    (get_flag(show),get_flag(metainfo)) ->
		(
		    daVinci_CP(Node)
		);true
	),
	col_0(Node,Col),
	prop_0_b(cp,Node,Col,Next1,Nextx,X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% coloring sets of nodes                                                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

color_all_0_b( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_0_b( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_0_or_i(Node,Col) ->
	    (
		CP2 = CP1
	    );
	    (
		col_0(Node,Col),
		prop_0_b(Sort,Node,Col,CP1,CP2,X)
	    )	    
	),
	color_all_0_b(Sort,Nodes,Col,CP2,CPx,X). 

color_all_0_rule( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_0_rule( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_0_or_i(Node,Col) ->
	    (
		CP2 = CP1
	    );
	    (
		col_0(Node,Col),
		prop_0_rule(Sort,Node,Col,CP1,CP2,X)
	    )	    
	),
	color_all_0_rule(Sort,Nodes,Col,CP2,CPx,X). 

color_all_0_h( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_0_h( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_0_or_i(Node,Col) ->
	    (
		CP2 = CP1
	    );
	    (
		col_0(Node,Col),
		prop_0_h(Sort,Node,Col,CP1,CP2,X)
	    )	    
	),
	color_all_0_h(Sort,Nodes,Col,CP2,CPx,X). 

color_all_1_b( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_1_b( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_1_or_i(Node,Col) -> 
	    (
		CP2 = CP1
	    );
	    (
		col_1(Node,Col),
		ignore_b(Node,Col),
		prop_1_b(Sort,Node,Col,CP1,CP2,X) 
	    )
	),
	color_all_1_b(Sort,Nodes,Col,CP2,CPx,X).

color_all_1_rule( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_1_rule( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_1_or_i(Node,Col) -> 
	    (
		CP2 = CP1
	    );
	    (
		col_1(Node,Col),
		ignore_rule(Node,Col),
		prop_1_rule(Sort,Node,Col,CP1,CP2,X) 
	    )
	),
	color_all_1_rule(Sort,Nodes,Col,CP2,CPx,X).

color_all_1_h( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_1_h( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_1_or_i(Node,Col) -> 
	    (
		CP2 = CP1
	    );
	    (
		col_1(Node,Col),
		prop_1_h(Sort,Node,Col,CP1,CP2,X) 
	    )
	),
	color_all_1_h(Sort,Nodes,Col,CP2,CPx,X).


ignore_b( Node, Col ) :-
	(
	    get_flag(ignore) ->
	    (
		sideward_prop_b(Node,Col)
	    );
	    true
	).
ignore_rule( Node, Col ) :-
	(
	    get_flag(ignore) ->
	    (
		sideward_prop_rule(Node,Col)
	    );
	    true
	).


sideward_prop_b( Node, Col ) :- 
	b_bs(Node,Bs),!,
	color_all_i(Bs,Col).

sideward_prop_rule( Node, Col ) :- 
	rule_rules(Node,Rs),!,
	color_all_i(Rs,Col).


color_all_2_rule( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_2_rule( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_1_or_2_or_i(Node,Col) -> 
	    (
		CP2 = CP1
	    );
	    (
		col_2(Node,Col),
		prop_1_rule(Sort,Node,Col,CP1,CP2,X) 
	    )
	),
	color_all_2_rule(Sort,Nodes,Col,CP2,CPx,X).

color_all_2_h( Sort, [], _Col, CP, CP, X ) :- in(X,In),out(Y,In),!.
color_all_2_h( Sort, [Node|Nodes], Col, CP1, CPx, X ) :-
	!,
	(
	    is_1_or_2_or_i(Node,Col) -> 
	    (
		CP2 = CP1
	    );
	    (
		col_2(Node,Col),
		prop_1_h(Sort,Node,Col,CP1,CP2,X) 
	    )
	),
	color_all_2_h(Sort,Nodes,Col,CP2,CPx,X).

color_all_i( [], _ ).
color_all_i( [Node|Nodes], Col ) :-
	!,
	(
	    is_u(Node,Col) -> 		
	    (
		col_i(Node,Col),
		color_all_i(Nodes,Col)
	    );
	    (
		color_all_i(Nodes,Col)
	    )
	).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% configuration of (back)propagation                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% PropType is in {cp,forw,forwback}
% cp       is for choices, that is backprop only over 1-arcs
% forw     is for forward propagation only 
% backfrow is for forward and backward (that isi full) propagation

% bodies
prop_1_b( cp, Node, Col, CP1, CPx, X ) :- 
	!,b_1_prop_cp(Node,Col,CP1,CPx,X).
prop_1_b( forw, Node, Col, CP1, CPx, X ) :- 
	!,b_1_prop_forw(Node,Col,CP1,CPx,X).
prop_1_b( forwback, Node, Col, CP1, CPx, X ) :- 
	!,b_1_prop(Node,Col,CP1,CPx,X).
prop_1_b( _, Node, Col, CP1, CPx, X ) :- 
	writeln(error:prop_1_b:b:undefined:sort:S),!,fail.

% rules
prop_1_rule( forw, Node, Col, CP1, CPx, X ) :- 
	!,rule_1_prop_forw(Node,Col,CP1,CPx,X).
prop_1_rule( forwback, Node, Col, CP1, CPx, X ) :- 
	!,rule_1_prop(Node,Col,CP1,CPx,X).

% heads
prop_1_h( forw, Node, Col, CP1, CPx, X ) :- 
	!,h_1_prop_forw(Node,Col,CP1,CPx,X).
prop_1_h( forwback, Node, Col, CP1, CPx, X ) :- 
	!,h_1_prop(Node,Col,CP1,CPx,X).

% bodies
prop_0_b( cp, Node, Col, CP1, CPx, X ) :- 
	!,b_0_prop_cp(Node,Col,CP1,CPx,X).
prop_0_b( forw, Node, Col, CP1, CPx, X ) :- 
	!,b_0_prop_forw(Node,Col,CP1,CPx,X).
prop_0_b( forwback, Node, Col, CP1, CPx, X ) :- 
	!,b_0_prop(Node,Col,CP1,CPx,X).
prop_0_b( _, Node, Col, CP1, CPx, X ) :- 
	writeln(error:prop_0:b:undefined:sort:S),!,fail.

% rules 
prop_0_rule( forw, Node, Col, CP1, CPx, X ) :- 
	!,rule_0_prop_forw(Node,Col,CP1,CPx,X).
prop_0_rule( forwback, Node, Col, CP1, CPx, X ) :- 
	!,rule_0_prop(Node,Col,CP1,CPx,X).

% heads
prop_0_h( forw, Node, Col, CP1, CPx, X ) :- 
	!,h_0_prop_forw(Node,Col,CP1,CPx,X).
prop_0_h( forwback, Node, Col, CP1, CPx, X ) :- 
	!,h_0_prop(Node,Col,CP1,CPx,X).

%
% bodies: Node is body
%
b_1_prop( Node, Col, CP1, CPx, X ) :- 
	!,
	(
	    get_flag(backprop) ->
	    (
		b_1_forw_rule_1(Node,Col,CP1,CP2,X),  % no cond.
		b_1_back_0_h_1(Node,Col,CP2,CP3,X),   % no cond.
		b_1_back_1_h_0(Node,Col,CP3,CPx,X)    % no cond.
	    );
	    (
		b_1_forw_rule_1(Node,Col,CP1,CPx,X)   % no cond.
	    )
	).

b_1_prop_forw( Node, Col, CP1, CPx, X ) :- 
	!,
	b_1_forw_rule_1(Node,Col,CP1,CPx,X).          % no cond.

b_1_prop_cp( Node, Col, CP1, CPx, X ) :-
	!,
	(
	    get_flag(backprop) ->
	    (
		b_1_back_1_h_0(Node,Col,CP1,CP2,X),   % no cond.
		b_1_forw_rule_1(Node,Col,CP2,CPx,X)   % no cond.
	    );
	    (
		b_1_forw_rule_1(Node,Col,CP1,CPx,X)   % no cond
	    )
	).

b_0_prop( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    (
		b_0_forw_rule_0(Node,Col,CP1,CP2,X),    
		b_0_back_1_h_1(Node,Col,CP2,CP3,X),
		b_0_back_0_h_0(Node,Col,CP3,CPx,X)
	    );
	    (
		b_0_forw_rule_0(Node,Col,CP1,CPx,X)
	    )
	).

b_0_prop_forw( Node, Col, CP1, CPx, X ) :-
	!,
	b_0_forw_rule_0(Node,Col,CP1,CPx,X).

b_0_prop_cp( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    (
		b_0_forw_rule_0(Node,Col,CP1,CP2,X),
		b_0_back_1_h_1(Node,Col,CP2,CPx,X) 
                % b_0_back_0_h_0(Node,Col,CP3,CPx,X), 
                % not neccessary, because all 0-pred of body-Node (CP) are
                % colored 1, that is Node (CP) is grounded
	    );
	    (
		b_0_forw_rule_0(Node,Col,CP1,CPx,X)
	    )
	).

%
% rules: Node is rule
%
rule_1_prop( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    (
		rule_1_forw_h_1(Node,Col,CP1,CP2,X),  % no cond
		rule_1_back_b_1(Node,Col,CP2,CPx,X) 
	    );
	    (
		rule_1_forw_h_1(Node,Col,CP1,CPx,X)   % no cond
	    )
	).

rule_1_prop_forw( Node, Col, CP1, CPx, X ) :-
	!,
	rule_1_forw_h_1(Node,Col,CP1,CPx,X).

rule_0_prop( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    (
		rule_0_back_b_0(Node,Col,CP1,CP2,X),  % no cond
		rule_0_forw_h_0(Node,Col,CP2,CPx,X) 
	    );
	    (
		rule_0_forw_h_0(Node,Col,CP1,CPx,X)
	    )
	).

rule_0_prop_forw( Node, Col, CP1, CPx, X ) :-
	!,
	rule_0_forw_h_0(Node,Col,CP1,CPx,X).

%
% heads: Node is head
%
h_1_prop( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    (
% ORDER IMPORTANT FOR BACKPROP and CYCLE CHECK!!!!!!!!!!!!!!!!!
% forw or back first?????
		h_1_forw_1_b_0(Node,Col,CP1,CP2,X),  % no cond
		h_1_back_rule_1(Node,Col,CP2,CP3,X),     % ORDER?
		h_1_forw_0_b_1(Node,Col,CP3,CPx,X)     % ORDER?!!!first
	    );
	    (
		h_1_forw_1_b_0(Node,Col,CP1,CP2,X),   % no cond
		h_1_forw_0_b_1(Node,Col,CP2,CPx,X)    
	    )
	).

h_1_prop_forw( Node, Col, CP1, CPx, X ) :-
	!,
	h_1_forw_1_b_0(Node,Col,CP1,CP2,X),           % no cond
	h_1_forw_0_b_1(Node,Col,CP2,CPx,X).    

h_0_prop( Node, Col, CP1, CPx, X ) :-
	!,
	( 
	    get_flag(backprop) -> 
	    ( % which order is better?? CHECK!!!!!!!!!!!!!!!!
		h_0_forw_0_b_0(Node,Col,CP1,CP2,X),   % no cond
		h_0_back_rule_0(Node,Col,CP2,CP3,X),  % no cond
		h_0_forw_1_b_1(Node,Col,CP3,CPx,X)
	    );
	    (
		h_0_forw_0_b_0(Node,Col,CP1,CP2,X),   % no cond
		h_0_forw_1_b_1(Node,Col,CP2,CPx,X)
	    )
	).

h_0_prop_forw( Node, Col, CP1, CPx, X ) :-
	!,
	h_0_forw_0_b_0(Node,Col,CP1,CP2,X),           % no cond
	h_0_forw_1_b_1(Node,Col,CP2,CPx,X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% propagation interface                                                   %
% each procedure name/5 calls corresponding procedure name/6              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% check_color( C, Sort, Node, Col, Caller )
% checks if Nodes which colore is going to propagated are already colored
% if an un colored node is going to propagated then fail!!!
check_color( 0, Sort, Node, Col, Caller ) :- 
	is_0(Node,Col) -> true;
	(
	    writeln(prop_error:Caller:node:Node:sort:Sort:color:0),!,fail
	).
check_color( 1, Sort, Node, Col, Caller ) :-
	is_1_or_2(Node,Col) -> true;
	(
	    writeln(prop_error:Caller:node:Node:sort:Sort:color:1),!,fail
	).
%
% bodies: Node is body
%
b_1_forw_rule_1( Node, Col, CP1, CPx, X ) :-
	check_color(1,b,Node,Col,b_1_forw_rule_1),
	!,
	b_rules(Node,Rs),
	b_1_forw_rule_1(Rs,Node,Col,CP1,CPx,X).

b_0_forw_rule_0( Node, Col, CP1, CPx, X ) :-  
	check_color(0,b,Node,Col,b_0_forw_rule_0),
	!,
	b_rules(Node,Rs),
	b_0_forw_rule_0(Rs,Node,Col,CP1,CPx,X).

b_1_back_1_h_0( Node, Col, CP1, CPx, X ) :- 
	check_color(1,b,Node,Col,b_1_back_1_h_0),
	!,
	b_1_hs(Node,Hs),
	b_1_back_1_h_0(Hs,Node,Col,CP1,CPx,X).

b_1_back_0_h_1(Node,Col,CP1,CPx,X) :- 
	check_color(1,b,Node,Col,b_1_back_0_h_1),
	!,
	b_0_hs(Node,Hs),
	b_1_back_0_h_1(Hs,Node,Col,CP1,CPx,X).

b_0_back_1_h_1(Node,Col,CP1,CPx,X) :- 
	check_color(0,b,Node,Col,b_0_back_1_h_1),
	!,
	b_1_hs(Node,Hs),
	b_0_back_1_h_1(Hs,Node,Col,CP1,CPx,X).

b_0_back_0_h_0(Node,Col,CP1,CPx,X) :- 
	check_color(0,b,Node,Col,b_0_back_0_h_0),
	!,
	b_0_hs(Node,Hs),
	b_0_back_0_h_0(Hs,Node,Col,CP1,CPx,X).

%
% rules: Node is rule
%
rule_1_forw_h_1( Node, Col, CP1, CPx, X ) :- 
	check_color(1,rule,Node,Col,rule_1_forw_h_1),
	!,
	rule_hs(Node,Hs),
	rule_1_forw_h_1(Hs,Node,Col,CP1,CPx,X).

rule_0_forw_h_0( Node, Col, CP1, CPx, X ) :-  
	check_color(0,rule,Node,Col,rule_0_forw_h_0),
	!,
	rule_hs(Node,Hs),
	rule_0_forw_h_0(Hs,Node,Col,CP1,CPx,X).

rule_1_back_b_1( Node, Col, CP1, CPx, X ) :- 
	check_color(1,rule,Node,Col,rule_1_back_b_1),
	!,
	rule_bs(Node,Bs),
	rule_1_back_b_1(Bs,Node,Col,CP1,CPx,X).

rule_0_back_b_0(Node,Col,CP1,CPx,X) :- 
	check_color(0,rule,Node,Col,rule_0_back_b_0),
	!,
	rule_bs(Node,Bs),
	rule_0_back_b_0(Bs,Node,Col,CP1,CPx,X).

%
% heads: Node is head
%
h_1_forw_1_b_0( Node, Col, CP1, CPx, X ) :- 
	check_color(1,h,Node,Col,h_1_forw_1_b_0),
	!,
	h_1_bs(Node,Bs),
	h_1_forw_1_b_0(Bs,Node,Col,CP1,CPx,X).

h_1_forw_0_b_1( Node, Col, CP1, CPx, X ) :- 
	check_color(1,h,Node,Col,h_1_forw_0_b_1),
	!,
	(Node == 3 -> hier;true),	
	h_0_bs(Node,Bs),
	h_1_forw_0_b_1(Bs,Node,Col,CP1,CPx,X).

h_0_forw_1_b_1( Node, Col, CP1, CPx, X ) :-  
	check_color(0,h,Node,Col,h_0_forw_1_b_1),
	!,
	h_1_bs(Node,Bs),
	h_0_forw_1_b_1(Bs,Node,Col,CP1,CPx,X).

h_0_forw_0_b_0( Node, Col, CP1, CPx, X ) :-  
	check_color(0,h,Node,Col,h_0_forw_0_b_0),
	!,
	h_0_bs(Node,Bs),
	h_0_forw_0_b_0(Bs,Node,Col,CP1,CPx,X).

h_1_back_rule_1( Node, Col, CP1, CPx, X ) :- 
	check_color(1,h,Node,Col,h_1_back_rule_1),
	!,
	h_rules(Node,Rs),
	h_1_back_rule_1(Rs,Node,Col,CP1,CPx,X).

h_0_back_rule_0(Node,Col,CP1,CPx,X) :- 
	check_color(0,h,Node,Col,h_0_back_rule_0),
	!,
	h_rules(Node,Rs),
	h_0_back_rule_0(Rs,Node,Col,CP1,CPx,X).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% propagation                                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% bodies:
%
b_1_forw_rule_1(Rs,Node,Col,CP1,CPx,X) :-
	is_1_or_2_x(Node,Col,Y), % Y can be given by caller
	!,
	(
	    Y == 1 ->
	    (
		color_all_1_rule(forw,Rs,Col,CP1,CPx,X)
	    );
	    (
		color_all_2_rule(forw,Rs,Col,CP1,CPx,X)
	    )
	).
	
b_0_forw_rule_0( [],     _Node, Col, CP,  CP,  X ) :- in(X,In),out(X,In),!.
b_0_forw_rule_0( [R|Rs],  Node, Col, CP1, CPx, X ) :-
	!,
	(
	    is_0_or_i(R,Col) ->
	    (
		b_0_forw_rule_0(Rs,Node,Col,CP1,CPx,X)
	    );
	    (
		(rule_bs(R,Bs) -> true;
		    (writeln(error:b_0_forw_rule_0:rule_bs:failed),fail)),
		(
		    forall_0(Bs,Col) ->
		    (
			col_0(R,Col),
			prop_0_rule(forw,R,Col,CP1,CP2,X),
			b_0_forw_rule_0(Rs,Node,Col,CP2,CPx,X)
		    );
		    (
			(
			    (
				%get_flag(jumping),
				get_flag(backprop),
				is_1_or_2(R,Col)
			    ) ->
			    (
				rule_1_back_b_1(R,Col,CP1,CP2,X)
			    );
			    (
				CP2 = CP1
			    )
			),
			b_0_forw_rule_0(Rs,Node,Col,CP2,CPx,X)
		    )
		)
	    )
	).

b_1_back_1_h_0( Hs, Node, Col, CP1, CPx, X ) :-
	!,
	color_all_0_h(forwback,Hs,Col,CP1,CPx,X).

b_1_back_0_h_1( Hs, Node, Col, CP1, CPx, X ) :-
	!,
	% color_all_2 is correct since here we cannot decide whether 
        % some head h is grounded or not. this can only be done for bodies!!
	color_all_2_h(forwback,Hs,Col,CP1,CPx,X).

b_0_back_1_h_1( Hs, Node, Col, CP1, CPx, X ) :-
	!,
	(
	    (   % weakly grounded
		w_grounded(Node,Col),
		forall_0_except_w(Hs,W,_HsRest,Col)
	    ) ->
	    (
		is_1_or_2_or_i(W,Col) -> 
		(
		    CP1 = CPx
		);
		(
		    (
			col_2(W,Col),
			prop_1_h(forwback,W,Col,CP1,CPx,X)
		    )
		)
	    );
	    (
		CP1 = CPx
	    )
	).


b_0_back_0_h_0( Hs, Node, Col, CP1, CPx, X ) :-
	!,
	(
	    (
		not_blocked(Node,Col),
		forall_1_except_w(Hs,W,_,Col)
	    ) ->
	    (
		is_0_or_i(W,Col) -> % sollte ueberfluesssig sein 
		%falls forall_1_except_w richtig funktioniert!!! -> 
						%CHECK!!!!!!!!!!!!!!!!!!
		(
		    CP1 = CPx
		);
		(
		    col_0(W,Col),
		    prop_0_h(forwback,W,Col,CP1,CPx,X)		    
		)
	    );
	    (
		CP1 = CPx
	    )
	).


%
% rules:
%
rule_1_forw_h_1( Hs, Node, Col, CP1, CPx, X ) :-
	is_1_or_2_x(Node,Col,Y),% Y can be given by caller
	!,
	(
	    Y == 1 ->
	    (
		color_all_1_h(forw,Hs,Col,CP1,CPx,X)
	    );
	    (
		color_all_2_h(forw,Hs,Col,CP1,CPx,X)
	    )
	).

rule_0_forw_h_0( [],     _Node, Col, CP,  CP,  X ) :- in(X,In),out(X,In),!.
rule_0_forw_h_0( [H|Hs],  Node, Col, CP1, CPx, X ) :-
	!,
	(
	    is_0_or_i(H,Col) ->
	    (
		rule_0_forw_h_0(Hs,Node,Col,CP1,CPx,X)
	    );
	    (
		h_rules(H,Rs),
		(
		    forall_0(Rs,Col) ->
		    (
			col_0(H,Col),
			prop_0_h(forw,H,Col,CP1,CP2,X),
			rule_0_forw_h_0(Hs,Node,Col,CP2,CPx,X)
		    );
		    (
			(
			    (
				%get_flag(jumping),
				get_flag(backprop),
				is_1_or_2(H,Col)
			    ) ->
			    (
				h_1_back_rule_1(H,Col,CP1,CP2,X)
			    );
			    (
				CP2 = CP1
			    )
			),
			rule_0_forw_h_0(Hs,Node,Col,CP2,CPx,X)
		    )
		)
	    )
	).


rule_1_back_b_1( Bs, Node, Col, CP1, CPx, X ) :-
	!,
	(
	    forall_0_except_w(Bs,W,_,Col) -> 
	    (
		can_be_grounded_x(W,Col,Y) -> % check for + colored cycels
		(
		    Y == 1 ->
		    (
			is_1_or_i(W,Col) -> 
			(
			    CP1 = CPx
			);
			(
			    col_1(W,Col),
			    ignore_b(W,Col),
			    prop_1_b(forwback,W,Col,CP1,CPx,X)
			)
		    );
		    ( % Y == u or Y == 0 (thatis, Y variable)
% why not is_2_or_i/3 here?
			col_2(W,Col),
			prop_1_b(forwback,W,Col,CP1,CPx,X)
		    )
		);
		(
		    CP1 =CPx
		)
	    );
	    (
		CP1 = CPx 
	    )
	).

rule_0_back_b_0( Bs, Node, Col, CP1, CPx, X ) :-
	!,
	color_all_0_b(forwback,Bs,Col,CP1,CPx,X).

%
% heads: Node is head 
%
h_1_forw_1_b_0( Bs, Node, Col, CP1, CPx, X ) :-
	!,
	color_all_0_b(forw,Bs,Col,CP1,CPx,X).

h_1_forw_0_b_1( [],    _Node, Col, CP,  CP,  X ) :- in(X,In),out(X,In),!.
h_1_forw_0_b_1( [B|Bs], Node, Col, CP1, CPx, X ) :-
	!,
	(
	    grounded_x(B,Col,Y) ->
	    (
		not_blocked(B,Col) ->
		(
		    Y == 1 ->
		    (
			is_1_or_i(B,Col) ->
			(
			    h_1_forw_0_b_1(Bs,Node,Col,CP1,CPx,X)
			);
			(
			    col_1(B,Col),
			    ignore_b(B,Col),
			    prop_1_b(forw,B,Col,CP1,CP2,X),
			    h_1_forw_0_b_1(Bs,Node,Col,CP2,CPx,X)
			)
		    );
		    (% Y == 2
			is_2_or_i(B,Col) ->
			(
			    h_1_forw_0_b_1(Bs,Node,Col,CP1,CPx,X)
			);
			(
			    col_2(B,Col),
			    prop_1_b(forw,B,Col,CP1,CP2,X),
			    h_1_forw_0_b_1(Bs,Node,Col,CP2,CPx,X)
			)
		    )
		);
		(
		    Y == 1 ->
		    (
			h_1_forw_0_b_1(Bs,Node,Col,CP1,CPxOut,X),
			ord_union([B],CPxOut,CPx)
		    );
		    (
			h_1_forw_0_b_1(Bs,Node,Col,CP1,CPx,X)
%			CP1 = CPx
		    )
		)
	    );
	    (
		(
		    (
			%get_flag(jumping),
			get_flag(backprop),
			is_0(B,Col)
		    ) ->
		    (
		        b_0_back_0_h_0(B,Col,CP1,CP2,X)
		    );
		    (
			CP2 = CP1
		    )
		),
		h_1_forw_0_b_1(Bs,Node,Col,CP2,CPx,X)
	    )
	).

h_0_forw_1_b_1( [],    _Node, Col, CP,  CP,  X ) :- in(X,In),out(X,In),!.
h_0_forw_1_b_1( [B|Bs], Node, Col, CP1, CPx, X ) :-
	!,
	(
	    (
		not_blocked(B,Col),
		grounded_x(B,Col,Y)
	    ) ->
	    (
		Y == 1 ->
		(
		    is_1_or_i(B,Col) ->
		    (
			h_0_forw_1_b_1(Bs,Node,Col,CP1,CPx,X)
		    );
		    (
			col_1(B,Col),
			ignore_b(B,Col),
			prop_1_b(forw,B,Col,CP1,CP2,X),
			h_0_forw_1_b_1(Bs,Node,Col,CP2,CPx,X)
		    )
		);
		(   % Y == 2 
		    is_2_or_i(B,Col) ->
		    (
			h_0_forw_1_b_1(Bs,Node,Col,CP1,CPx,X)
		    );
		    (
			col_2(B,Col),
			prop_1_b(forw,B,Col,CP1,CP2,X),
			h_0_forw_1_b_1(Bs,Node,Col,CP2,CPx,X)
		    )
		)
	    );
	    (
		(
		    (
			%get_flag(jumping),
			get_flag(backprop),
			is_0(B,Col)
		    ) ->
		    (
		        b_0_back_1_h_1(B,Col,CP1,CP2,X)
		    );
		    (
			CP2 = CP1
		    )
		),
		h_0_forw_1_b_1(Bs,Node,Col,CP2,CPx,X)
	    )
	).
	

h_0_forw_0_b_0( Bs, Node, Col, CP1, CPx, X ) :-
	!,
	color_all_0_b(forw,Bs,Col,CP1,CPx,X).

h_1_back_rule_1( Rs, Node, Col, CP1, CPx, X ) :-
	!,
	(
	    (
		forall_0_except_w(Rs,W,_,Col)
	    ) ->
	    (
		is_2_or_i(W,Col) ->
		(
		    CP1 =CPx
		);
		(
		    col_2(W,Col),
		    prop_1_rule(forwback,W,Col,CP1,CPx,X)
		)
	    );
	    (
%		CP1 = CPx => fail on corr. of zeroloops.lp
		FailCond == fail -> (!,fail);CP1 = CPx 
%=> fail on corr. of zeroloops.lp
% sollte hier failen!!!! 
%CHECK!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	    )
	).

h_0_back_rule_0( Rs, Node, Col, CP1, CPx, X ) :-
	!,
	color_all_0_rule(forwback,Rs,Col,CP1,CPx,X).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% logical conditions for model [B->R->H-0/1->B] for bodies                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

grounded_x( Body, Col, X ) :-
	b_0_hs(Body,Hs),!,
	forall_1_or_2_x(Hs,Col,X).

can_be_grounded_x( Body, Col, X ) :-
	b_0_hs(Body,Hs),!,
	forall_1_or_u_x(Hs,Col,X).

% weakly grounded
w_grounded( Body, Col ) :-
	b_0_hs(Body,Hs),!,
	forall_1_or_2(Hs,Col).

not_blocked( Body, Col ) :-
	b_1_hs(Body,Hs),!,
	forall_0(Hs,Col).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% pure logical conditions on sets of nodes                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% forall conditions
%
forall_1_or_u( [],    _Col ) :- !.
forall_1_or_u( [H|Hs], Col ) :- 
	is_1_or_u(H,Col),!,
	forall_1_or_u(Hs,Col).

forall_1_or_2( [],    _Col ) :- !.
forall_1_or_2( [H|Hs], Col ) :- 
	is_1_or_2(H,Col),!,
	forall_1_or_2(Hs,Col).

forall_1_or_2_x( [], Col, X ) :- 
	(
	    var(X) -> (X = 1);(true)
	),
	!. 
forall_1_or_2_x( [H|Hs], Col, X ) :- 
	!,
	is_1_or_2_x(H,Col,Y),
	(
	    Y == 2 -> (X = 2);(true)
	),
	forall_1_or_2_x(Hs,Col,X).


forall_1_or_u_x( [], Col, X ) :- 
	(
	    var(X) -> (X = 1);(true)
	),
	!. 
forall_1_or_u_x( [H|Hs], Col, X ) :- 
	!,
	is_1_or_u_x(H,Col,Y),
	(
	    Y == u -> (X = u);(true)
	),
	forall_1_or_u_x(Hs,Col,X).


forall_0_or_i( [],        _ )   :- !.
forall_0_or_i( [Node|Ns], Col ) :-
	is_0_or_i(Node,Col),!,
	forall_0_or_i(Ns,Col).

forall_0( [],        _ )   :- !.
forall_0( [Node|Ns], Col ) :-
	is_0(Node,Col),!,
	forall_0(Ns,Col).

forall_1( [],        _ )   :- !.
forall_1( [Node|Ns], Col ) :-
	is_1(Node,Col),!,
	forall_1(Ns,Col).

%
% forall_except conditions
%

% forall_0_except_w(+Sort,+Ns,-W,-RestList,+Col) true iff 
% W is some node in Ns which is uncolored wrt Col and 
% all nodes in Rest = List-W are colored 0.
forall_0_except_w( [X|Ns], W , [X|RestNs], Col ) :-
	is_0(X,Col),
	!,
	forall_0_except_w(Ns,W,RestNs,Col).
forall_0_except_w( [W|Ns], W, Ns, Col ) :-
	is_u(W,Col),
	!,
	forall_0(Ns,Col).

% forall_1_except_w(+Sort,+Ns,-W,-RestList,+Col) true iff 
% W is some node in Ns which is uncolored wrt Col and 
% all nodes in Rest = List-W are colored 1.
forall_1_except_w([X|Ns], W , [X|RestNs], Col ) :-
	is_1_or_2(X,Col),
	!,
	forall_1_except_w(Ns,W,RestNs,Col ).
forall_1_except_w( [W|Ns], W, Ns, Col ) :-
	is_u(W,Col),
	!,
	forall_1(Ns,Col). 

































